/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public final class PredefinedSymbols {
    private static final Logger LOGGER = Logger.getLogger(PredefinedSymbols.class.getName());
    public static final Collection<String> SUPERGLOBALS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("GLOBALS", "_SERVER", "_GET", "_POST", "_FILES", "_COOKIE", "_SESSION", "_REQUEST", "_ENV", "php_errormsg", "HTTP_RAW_POST_DATA", "http_response_header", "argc", "argv")));
    public static final List<String> SERVER_ENTRY_CONSTANTS = Collections.unmodifiableList(Arrays.asList("PHP_SELF", "GATEWAY_INTERFACE", "SERVER_ADDR", "SERVER_NAME", "SERVER_SOFTWARE", "SERVER_PROTOCOL", "REQUEST_METHOD", "QUERY_STRING", "DOCUMENT_ROOT", "HTTP_ACCEPT", "HTTP_ACCEPT_CHARSET", "HTTP_ACCEPT_ENCODING", "HTTP_ACCEPT_LANGUAGE", "HTTP_CONNECTION", "HTTP_HOST", "HTTP_REFERER", "HTTP_USER_AGENT", "HTTPS", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_PORT", "SCRIPT_FILENAME", "SERVER_ADMIN", "SERVER_PORT", "SERVER_SIGNATURE", "PATH_TRANSLATED", "SCRIPT_NAME", "REQUEST_URI", "PHP_AUTH_DIGEST", "PHP_AUTH_USER", "PHP_AUTH_PW", "AUTH_TYPE"));
    public static final Set<String> MAGIC_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("__callStatic", "__set_state", "__call", "__clone", "__construct", "__destruct", "__get", "__set", "__isset", "__unset", "__sleep", "__wakeup", "__toString", "__serialize", "__unserialize")));
    private static String docURLBase;

    private PredefinedSymbols() {
    }

    private static void initDoc() {
        File file = InstalledFileLocator.getDefault().locate("docs/predefined_vars.zip", null, true);
        if (file != null) {
            try {
                URL urll = Utilities.toURI((File)file).toURL();
                urll = FileUtil.getArchiveRoot((URL)urll);
                docURLBase = urll.toString();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }
    }

    public static boolean isSuperGlobalName(String name) {
        return SUPERGLOBALS.contains(name);
    }

    public static String getDocumentation(String name) {
        if (docURLBase == null) {
            PredefinedSymbols.initDoc();
        }
        String resPath = String.format("%s%s.desc", docURLBase, name);
        try {
            ByteArrayOutputStream baos;
            URL url = new URL(resPath);
            try (InputStream is = url.openStream();){
                int count;
                byte[] buffer = new byte[1000];
                baos = new ByteArrayOutputStream();
                do {
                    if ((count = is.read(buffer)) <= 0) continue;
                    baos.write(buffer, 0, count);
                } while (count > 0);
            }
            String text = baos.toString(Charset.defaultCharset().name());
            baos.close();
            return text;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static enum VariableKind {
        STANDARD,
        THIS,
        SELF,
        PARENT;

    }
}

