/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;

final class MethodValidator
implements MemberValidator {
    private TreePathHandle target;
    private String name;
    private final Source theSource;
    private final List<TreePathHandle> parameters;
    private final TypeMirrorHandle returnType;
    private MemberSearchResult result;

    public MethodValidator(Source theSource, List<TreePathHandle> parameters, TypeMirrorHandle returnType) {
        this.theSource = theSource;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public MemberSearchResult getResult() {
        return this.result;
    }

    @Override
    public synchronized MemberSearchResult validateName(TreePathHandle type, String n) {
        if (!type.equals((Object)this.target) || !n.equals(this.name)) {
            SearchWorker wrk = new SearchWorker(type, n);
            try {
                ParserManager.parse(Collections.singleton(this.theSource), (UserTask)wrk);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.result = wrk.result;
            this.name = n;
        }
        return this.result;
    }

    private class SearchWorker
    extends UserTask
    implements ElementUtilities.ElementAcceptor {
        private final TreePathHandle targetHandle;
        private final String name;
        private MemberSearchResult result;
        private CompilationInfo cinfo;
        private Scope initialScope;
        private TypeElement target;
        private DeclaredType targetType;
        private List<TypeMirror> paramTypes;
        private Collection<Element> erasures = new HashSet<Element>();
        private TypeMirror returnType;

        public SearchWorker(TreePathHandle type, String name) {
            this.targetHandle = type;
            this.name = name;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Scope scope;
            CompilationController parameter = CompilationController.get((Parser.Result)resultIterator.getParserResult());
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            this.cinfo = parameter;
            TreePath targetPath = this.targetHandle.resolve(this.cinfo);
            if (targetPath == null) {
                return;
            }
            Element te = this.cinfo.getTrees().getElement(targetPath);
            if (te == null || !te.getKind().isClass() && !te.getKind().isInterface()) {
                return;
            }
            this.target = (TypeElement)te;
            TypeMirror m = this.target.asType();
            if (m.getKind() != TypeKind.DECLARED) {
                return;
            }
            this.targetType = (DeclaredType)m;
            this.returnType = MethodValidator.this.returnType.resolve(this.cinfo);
            if (this.returnType == null) {
                return;
            }
            this.paramTypes = new ArrayList<TypeMirror>(MethodValidator.this.parameters.size());
            for (TreePathHandle tph : MethodValidator.this.parameters) {
                Element el = tph.resolveElement(this.cinfo);
                if (el == null || el.getKind() != ElementKind.PARAMETER && el.getKind() != ElementKind.LOCAL_VARIABLE && el.getKind() != ElementKind.RESOURCE_VARIABLE && el.getKind() != ElementKind.EXCEPTION_PARAMETER) {
                    return;
                }
                this.paramTypes.add(el.asType());
            }
            DeclaredType targetType = (DeclaredType)this.target.asType();
            this.initialScope = scope = this.cinfo.getTrees().getScope(targetPath);
            Map visibleMethods = this.cinfo.getElementUtilities().findElementsAndOrigins(scope, (ElementUtilities.ElementAcceptor)this);
            for (Element e : visibleMethods.keySet()) {
                ExecutableElement ee = (ExecutableElement)e;
                TypeElement owner = ((Scope)visibleMethods.get(e)).getEnclosingClass();
                Element clazz = e.getEnclosingElement();
                if (clazz == this.target || owner == null || owner == this.target && this.erasures.contains(e) || !this.cinfo.getTypes().isSubtype(this.returnType, ee.getReturnType())) {
                    this.result = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)ee));
                    return;
                }
                Modifier mod = null;
                if (!owner.getKind().isClass() && !owner.getKind().isInterface()) continue;
                ElementHandle ownerHandle = ElementHandle.create((Element)owner);
                if (!e.getModifiers().contains((Object)Modifier.STATIC) && owner == this.target) {
                    Set<Modifier> mods = ee.getModifiers();
                    if (mods.contains((Object)Modifier.PUBLIC)) {
                        mod = Modifier.PUBLIC;
                    } else if (mods.contains((Object)Modifier.PROTECTED)) {
                        mod = Modifier.PROTECTED;
                    } else if (!mods.contains((Object)Modifier.PRIVATE)) {
                        mod = Modifier.DEFAULT;
                    }
                    this.result = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)ee), (ElementHandle<? extends TypeElement>)ownerHandle, mod);
                    return;
                }
                this.result = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)ee), (ElementHandle<? extends TypeElement>)ownerHandle);
            }
        }

        public boolean accept(Element e, TypeMirror type) {
            if (e.getKind() != ElementKind.METHOD) {
                return false;
            }
            ExecutableElement ee = (ExecutableElement)e;
            if (ee.getParameters().size() != MethodValidator.this.parameters.size()) {
                return false;
            }
            if (!ee.getSimpleName().contentEquals(this.name)) {
                return false;
            }
            if (type != null && !this.cinfo.getTrees().isAccessible(this.initialScope, ee, (DeclaredType)type)) {
                return false;
            }
            ExecutableType eeType = (ExecutableType)this.cinfo.getTypes().asMemberOf((DeclaredType)type, ee);
            boolean checkErasure = false;
            DeclaredType parentType = (DeclaredType)ee.getEnclosingElement().asType();
            if (parentType != null && this.cinfo.getTypes().isSubtype(this.targetType, parentType)) {
                checkErasure = true;
            }
            boolean erasureUsed = false;
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                TypeMirror existing = eeType.getParameterTypes().get(i);
                TypeMirror pt = this.paramTypes.get(i);
                if (this.cinfo.getTypes().isSubtype(pt, existing)) continue;
                if (!checkErasure) {
                    return false;
                }
                if (!checkErasure) continue;
                TypeMirror e1 = this.cinfo.getTypes().erasure(pt);
                TypeMirror e2 = this.cinfo.getTypes().erasure(existing);
                if (!this.cinfo.getTypes().isSameType(e1, e2)) {
                    return false;
                }
                erasureUsed = true;
            }
            if (erasureUsed) {
                this.erasures.add(ee);
            }
            return true;
        }
    }
}

