/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.WrongStringComparisonCustomizer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WrongStringComparison {
    static final String TERNARY_NULL_CHECK = "ternary-null-check";
    static final String STRING_LITERALS_FIRST = "string-literals-first";
    private static final String STRING_TYPE = "java.lang.String";

    public static ErrorDescription run(HintContext ctx) {
        TypeMirror rightType;
        CompilationInfo info = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Tree t = treePath.getLeaf();
        BinaryTree bt = (BinaryTree)t;
        TreePath left = new TreePath(treePath, bt.getLeftOperand());
        TreePath right = new TreePath(treePath, bt.getRightOperand());
        Trees trees = info.getTrees();
        TypeMirror leftType = left == null ? null : trees.getTypeMirror(left);
        TypeMirror typeMirror = rightType = right == null ? null : trees.getTypeMirror(right);
        if (leftType != null && rightType != null && STRING_TYPE.equals(leftType.toString()) && STRING_TYPE.equals(rightType.toString())) {
            if (WrongStringComparison.checkInsideGeneratedEquals(ctx, treePath, left.getLeaf(), right.getLeaf())) {
                return null;
            }
            FileObject file = info.getFileObject();
            TreePathHandle tph = TreePathHandle.create((TreePath)treePath, (CompilationInfo)info);
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            boolean reverseOperands = false;
            if (bt.getLeftOperand().getKind() != Tree.Kind.STRING_LITERAL) {
                if (bt.getRightOperand().getKind() == Tree.Kind.STRING_LITERAL) {
                    if (WrongStringComparison.getStringLiteralsFirst(ctx.getPreferences())) {
                        reverseOperands = true;
                    } else {
                        fixes.add(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.NULL_CHECK).toEditorFix());
                    }
                } else {
                    fixes.add(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.ternaryNullCheck(WrongStringComparison.getTernaryNullCheck(ctx.getPreferences()))).toEditorFix());
                }
            }
            fixes.add(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.reverseOperands(reverseOperands)).toEditorFix());
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)t, (String)NbBundle.getMessage(WrongStringComparison.class, (String)"LBL_WrongStringComparison"), (Fix[])fixes.toArray(new Fix[0]));
        }
        return null;
    }

    private static boolean checkInsideGeneratedEquals(HintContext ctx, TreePath treePath, Tree left, Tree right) {
        CompilationInfo info = ctx.getInfo();
        TreePath sourcePathParent = treePath.getParentPath();
        if (sourcePathParent.getLeaf().getKind() != Tree.Kind.CONDITIONAL_AND) {
            return false;
        }
        SourcePositions sp = info.getTrees().getSourcePositions();
        Scope s = info.getTrees().getScope(sourcePathParent);
        String leftText = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), left), (int)sp.getEndPosition(info.getCompilationUnit(), left) + 1);
        String rightText = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), right), (int)sp.getEndPosition(info.getCompilationUnit(), right) + 1);
        String code = leftText + " != " + rightText + " && (" + leftText + "== null || !" + leftText + ".equals(" + rightText + "))";
        ExpressionTree correct = info.getTreeUtilities().parseExpression(code, new SourcePositions[1]);
        info.getTreeUtilities().attributeTree((Tree)correct, s);
        TreePath correctPath = new TreePath(sourcePathParent.getParentPath(), correct);
        String originalCode = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), sourcePathParent.getLeaf()), (int)sp.getEndPosition(info.getCompilationUnit(), sourcePathParent.getLeaf()) + 1);
        ExpressionTree original = info.getTreeUtilities().parseExpression(originalCode, new SourcePositions[1]);
        info.getTreeUtilities().attributeTree((Tree)original, s);
        TreePath originalPath = new TreePath(sourcePathParent.getParentPath(), original);
        return Matcher.create((CompilationInfo)info).setSearchRoot(originalPath).setTreeTopSearch().match(Pattern.createSimplePattern((TreePath)correctPath)).iterator().hasNext();
    }

    static boolean getTernaryNullCheck(Preferences p) {
        return p.getBoolean(TERNARY_NULL_CHECK, true);
    }

    static boolean getStringLiteralsFirst(Preferences p) {
        return p.getBoolean(STRING_LITERALS_FIRST, true);
    }

    static void setTernaryNullCheck(Preferences p, boolean selected) {
        p.putBoolean(TERNARY_NULL_CHECK, selected);
    }

    static void setStringLiteralsFirst(Preferences p, boolean selected) {
        p.putBoolean(STRING_LITERALS_FIRST, selected);
    }

    public static final class WrongStringComparisonCustomizerProvider
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            WrongStringComparisonCustomizer customizer = new WrongStringComparisonCustomizer(prefs);
            prefs.putBoolean(WrongStringComparison.STRING_LITERALS_FIRST, WrongStringComparison.getStringLiteralsFirst(prefs));
            prefs.putBoolean(WrongStringComparison.TERNARY_NULL_CHECK, WrongStringComparison.getTernaryNullCheck(prefs));
            return customizer;
        }
    }

    static class WrongStringComparisonFix
    extends JavaFix {
        protected final Kind kind;

        public WrongStringComparisonFix(TreePathHandle tph, Kind kind) {
            super(tph);
            this.kind = kind;
        }

        public String getText() {
            switch (this.kind) {
                case REVERSE_OPERANDS: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_ReverseOperands");
                }
                case NO_NULL_CHECK: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NoNullCheck");
                }
                case NULL_CHECK_TERNARY: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_TernaryNullCheck");
                }
            }
            return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NullCheck");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            if (path != null) {
                ExpressionTree newTree;
                TreeMaker make = copy.getTreeMaker();
                BinaryTree oldTree = (BinaryTree)path.getLeaf();
                ExpressionTree left = oldTree.getLeftOperand();
                ExpressionTree right = oldTree.getRightOperand();
                if (this.kind == Kind.REVERSE_OPERANDS) {
                    MemberSelectTree rightEquals = make.MemberSelect(right, (CharSequence)"equals");
                    ExpressionTree rightEqualsLeft = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)rightEquals, Collections.singletonList(left));
                    newTree = rightEqualsLeft = this.matchSign(make, oldTree, rightEqualsLeft);
                } else {
                    MemberSelectTree leftEquals = make.MemberSelect(left, (CharSequence)"equals");
                    ExpressionTree leftEqualsRight = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)leftEquals, Collections.singletonList(right));
                    leftEqualsRight = this.matchSign(make, oldTree, leftEqualsRight);
                    if (this.kind == Kind.NO_NULL_CHECK) {
                        newTree = leftEqualsRight;
                    } else {
                        BinaryTree leftEqNull = make.Binary(Tree.Kind.EQUAL_TO, left, (ExpressionTree)make.Identifier((CharSequence)"null"));
                        BinaryTree rightEqNull = make.Binary(oldTree.getKind(), right, (ExpressionTree)make.Identifier((CharSequence)"null"));
                        if (this.kind == Kind.NULL_CHECK_TERNARY) {
                            newTree = make.ConditionalExpression((ExpressionTree)leftEqNull, (ExpressionTree)rightEqNull, leftEqualsRight);
                        } else {
                            BinaryTree leftNeNull = make.Binary(Tree.Kind.NOT_EQUAL_TO, left, (ExpressionTree)make.Identifier((CharSequence)"null"));
                            BinaryTree leftNeNullAndLeftEqualsRight = make.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)leftNeNull, leftEqualsRight);
                            if (right.getKind() == Tree.Kind.STRING_LITERAL) {
                                newTree = leftNeNullAndLeftEqualsRight;
                            } else {
                                BinaryTree leftEqNullAndRightEqNull = make.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)leftEqNull, (ExpressionTree)rightEqNull);
                                newTree = make.Binary(Tree.Kind.CONDITIONAL_OR, (ExpressionTree)make.Parenthesized((ExpressionTree)leftEqNullAndRightEqNull), (ExpressionTree)make.Parenthesized((ExpressionTree)leftNeNullAndLeftEqualsRight));
                            }
                        }
                        if (path.getParentPath().getLeaf().getKind() != Tree.Kind.PARENTHESIZED) {
                            newTree = make.Parenthesized(newTree);
                        }
                    }
                }
                copy.rewrite((Tree)oldTree, (Tree)newTree);
            }
        }

        ExpressionTree matchSign(TreeMaker make, BinaryTree oldTree, ExpressionTree et) {
            if (oldTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                return make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, et);
            }
            return et;
        }

        static enum Kind {
            REVERSE_OPERANDS,
            NO_NULL_CHECK,
            NULL_CHECK,
            NULL_CHECK_TERNARY;


            public static Kind ternaryNullCheck(boolean ternary) {
                return ternary ? NULL_CHECK_TERNARY : NULL_CHECK;
            }

            public static Kind reverseOperands(boolean reverseOperands) {
                return reverseOperands ? REVERSE_OPERANDS : NO_NULL_CHECK;
            }
        }
    }
}

