/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.utils;

import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class SafeSimpleDateFormat {
    private final String _format;
    private static final ThreadLocal<Map<String, SimpleDateFormat>> _dateFormats = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        public Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    private SimpleDateFormat getDateFormat(String format) {
        Map<String, SimpleDateFormat> formatters = _dateFormats.get();
        SimpleDateFormat formatter = formatters.get(format);
        if (formatter == null) {
            formatter = new SimpleDateFormat(format);
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            formatters.put(format, formatter);
        }
        return formatter;
    }

    public SafeSimpleDateFormat(String format) {
        this._format = format;
    }

    public String format(Date date) {
        return this.getDateFormat(this._format).format(date);
    }

    public String format(Object date) {
        return this.getDateFormat(this._format).format(date);
    }

    public Date parse(String day) throws ParseException {
        return this.getDateFormat(this._format).parse(day);
    }

    public void setTimeZone(TimeZone tz) {
        this.getDateFormat(this._format).setTimeZone(tz);
    }

    public void setCalendar(Calendar cal) {
        this.getDateFormat(this._format).setCalendar(cal);
    }

    public void setNumberFormat(NumberFormat format) {
        this.getDateFormat(this._format).setNumberFormat(format);
    }

    public void setLenient(boolean lenient) {
        this.getDateFormat(this._format).setLenient(lenient);
    }

    public void setDateFormatSymbols(DateFormatSymbols symbols) {
        this.getDateFormat(this._format).setDateFormatSymbols(symbols);
    }

    public void set2DigitYearStart(Date date) {
        this.getDateFormat(this._format).set2DigitYearStart(date);
    }
}

