/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.actions;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class GoToNodeSourceAction
extends NodeAction {
    private static final RequestProcessor RP = new RequestProcessor(GoToNodeSourceAction.class);

    protected void performAction(org.openide.nodes.Node[] activatedNodes) {
        org.openide.nodes.Node selection = activatedNodes[0];
        Node node = (Node)selection.getLookup().lookup(Node.class);
        Resource resource = this.getNodeOrigin(selection);
        FileObject fob = resource.toFileObject();
        if (fob == null) {
            return;
        }
        try {
            Source source = Source.create((FileObject)fob);
            if (source != null) {
                ParserManager.parse(Collections.singleton(source), (UserTask)new GoToNodeTask(node, fob));
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(GoToNodeSourceAction.class.getName()).log(Level.INFO, null, ex);
        }
    }

    protected boolean enable(org.openide.nodes.Node[] activatedNodes) {
        if (activatedNodes.length == 1) {
            org.openide.nodes.Node selection = activatedNodes[0];
            Node node = (Node)selection.getLookup().lookup(Node.class);
            if (node == null) {
                return false;
            }
            final Resource resource = this.getNodeOrigin(selection);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    FileObject fob = resource.toFileObject();
                    if (fob == null || !fob.isData()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GoToNodeSourceAction.this.setEnabled(false);
                            }
                        });
                    }
                }
            });
            return true;
        }
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return super.getMenuPresenter();
    }

    private Resource getNodeOrigin(org.openide.nodes.Node node) {
        org.openide.nodes.Node parent;
        Resource resource = (Resource)node.getLookup().lookup(Resource.class);
        if (resource == null && (parent = node.getParentNode()) != null) {
            resource = this.getNodeOrigin(parent);
        }
        return resource;
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(GoToNodeSourceAction.class, (String)"GoToNodeSourceAction.displayName");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static class GoToNodeTask
    extends UserTask {
        private final Node node;
        private final FileObject fob;

        GoToNodeTask(Node node, FileObject fob) {
            this.node = node;
            this.fob = fob;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            int offsetToShow;
            ResultIterator htmlResultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
            if (htmlResultIterator == null) {
                offsetToShow = 0;
            } else {
                HtmlParsingResult result = (HtmlParsingResult)htmlResultIterator.getParserResult();
                org.netbeans.modules.html.editor.lib.api.elements.Node nodeToShow = Utilities.findNode(result, this.node);
                Snapshot snapshot = htmlResultIterator.getSnapshot();
                int snapshotOffset = nodeToShow.from();
                offsetToShow = snapshot.getOriginalOffset(snapshotOffset);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSSUtils.openAtOffset(fob, offsetToShow);
                }
            });
        }
    }
}

