/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.ResourceRequest;
import org.springframework.mock.web.portlet.MockClientDataRequest;
import org.springframework.mock.web.portlet.MockResourceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResourceRequest
extends MockClientDataRequest
implements ResourceRequest {
    private String resourceID;
    private String cacheability;
    private final Map<String, String[]> privateRenderParameterMap = new LinkedHashMap<String, String[]>();

    public MockResourceRequest() {
    }

    public MockResourceRequest(String resourceID) {
        this.resourceID = resourceID;
    }

    public MockResourceRequest(MockResourceURL url) {
        this.resourceID = url.getResourceID();
        this.cacheability = url.getCacheability();
    }

    public MockResourceRequest(PortletContext portletContext) {
        super(portletContext);
    }

    public MockResourceRequest(PortalContext portalContext, PortletContext portletContext) {
        super(portalContext, portletContext);
    }

    @Override
    protected String getLifecyclePhase() {
        return "RESOURCE_PHASE";
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setCacheability(String cacheLevel) {
        this.cacheability = cacheLevel;
    }

    public String getCacheability() {
        return this.cacheability;
    }

    public String getETag() {
        return this.getProperty("portlet.ETag");
    }

    public void addPrivateRenderParameter(String key, String value) {
        this.privateRenderParameterMap.put(key, new String[]{value});
    }

    public void addPrivateRenderParameter(String key, String[] values) {
        this.privateRenderParameterMap.put(key, values);
    }

    public Map<String, String[]> getPrivateRenderParameterMap() {
        return Collections.unmodifiableMap(this.privateRenderParameterMap);
    }
}

