/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SQLHistoryManager {
    public static final String OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY = "SQL_STATEMENTS_SAVED_FOR_HISTORY";
    public static final int DEFAULT_SQL_STATEMENTS_SAVED_FOR_HISTORY = 100;
    public static final int MAX_SQL_STATEMENTS_SAVED_FOR_HISTORY = 10000;
    public static final String PROP_SAVED = "saved";
    private static final String SQL_HISTORY_DIRECTORY = "Databases/SQLHISTORY";
    private static final String SQL_HISTORY_FILE = "sql_history.xml";
    private static final String TAG_HISTORY = "history";
    private static final String TAG_SQL = "sql";
    private static final String ATTR_DATE = "date";
    private static final String ATTR_URL = "url";
    private static final String CONTENT_NEWLINE = "\n";
    private static final Logger LOGGER = Logger.getLogger(SQLHistoryEntry.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(SQLHistoryManager.class.getName(), 1, false, false);
    private static final int SAVE_DELAY = 5000;
    private static SQLHistoryManager _instance = null;
    private final RequestProcessor.Task SAVER = RP.create((Runnable)new Saver());
    private final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(this);
    private SQLHistory sqlHistory;

    protected SQLHistoryManager() {
        this.loadHistory();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (SQLHistoryManager.this.SAVER.getDelay() > 0) {
                    SQLHistoryManager.this.SAVER.schedule(0);
                    SQLHistoryManager.this.SAVER.waitFinished();
                }
            }
        });
    }

    public static synchronized SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return NbPreferences.forModule(SQLHistoryPanel.class).getInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", 100);
    }

    protected FileObject getHistoryRoot(boolean create) throws IOException {
        FileObject result = null;
        FileObject historyRootDir = this.getConfigRoot().getFileObject(this.getRelativeHistoryPath());
        if (historyRootDir != null || create) {
            FileObject historyRoot;
            if (historyRootDir == null) {
                historyRootDir = FileUtil.createFolder((FileObject)this.getConfigRoot(), (String)this.getRelativeHistoryPath());
            }
            if ((historyRoot = historyRootDir.getFileObject(this.getHistoryFilename())) != null || create) {
                if (historyRoot == null) {
                    historyRoot = historyRootDir.createData(this.getHistoryFilename());
                }
                result = historyRoot;
            }
        }
        return result;
    }

    protected FileObject getConfigRoot() {
        return FileUtil.getConfigRoot();
    }

    protected String getRelativeHistoryPath() {
        return SQL_HISTORY_DIRECTORY;
    }

    protected String getHistoryFilename() {
        return SQL_HISTORY_FILE;
    }

    public void setListSize(int listSize) {
        NbPreferences.forModule(SQLHistoryPanel.class).putInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", listSize);
        this.sqlHistory.setHistoryLimit(listSize);
    }

    public void saveSQL(SQLHistoryEntry sqlStored) {
        this.sqlHistory.add(sqlStored);
    }

    private void loadHistory() {
        try {
            DocumentBuilder db;
            Document doc;
            Element rootElement;
            this.sqlHistory = new SQLHistory();
            FileObject historyFile = this.getHistoryRoot(false);
            if (historyFile != null && TAG_HISTORY.equals((rootElement = (doc = (db = DocumentBuilderFactory.newInstance().newDocumentBuilder()).parse(historyFile.getInputStream())).getDocumentElement()).getTagName())) {
                NodeList sqlNodes = rootElement.getElementsByTagName(TAG_SQL);
                for (int i = 0; i < sqlNodes.getLength(); ++i) {
                    Element sql = (Element)sqlNodes.item(i);
                    SQLHistoryEntry sqe = new SQLHistoryEntry();
                    sqe.setDateXMLVariant(sql.getAttribute(ATTR_DATE));
                    sqe.setUrl(sql.getAttribute(ATTR_URL));
                    sqe.setSql(sql.getTextContent());
                    this.sqlHistory.add(sqe);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            this.sqlHistory = new SQLHistory();
            LOGGER.log(Level.INFO, ex.getMessage());
        }
        this.sqlHistory.setHistoryLimit(this.getListSize());
    }

    public void save() {
        if (this.SAVER.getDelay() == 0) {
            this.SAVER.schedule(5000);
        }
    }

    public SQLHistory getSQLHistory() {
        return this.sqlHistory;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(listener);
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        @Override
        public void run() {
            try {
                final FileObject targetFile = SQLHistoryManager.this.getHistoryRoot(true);
                targetFile.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        try (OutputStream os = targetFile.getOutputStream();){
                            XMLStreamWriter xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(os);
                            xsw.writeStartDocument();
                            xsw.writeCharacters(SQLHistoryManager.CONTENT_NEWLINE);
                            xsw.writeStartElement(SQLHistoryManager.TAG_HISTORY);
                            xsw.writeCharacters(SQLHistoryManager.CONTENT_NEWLINE);
                            for (SQLHistoryEntry sqe : SQLHistoryManager.this.sqlHistory) {
                                xsw.writeStartElement(SQLHistoryManager.TAG_SQL);
                                xsw.writeAttribute(SQLHistoryManager.ATTR_DATE, sqe.getDateXMLVariant());
                                xsw.writeAttribute(SQLHistoryManager.ATTR_URL, sqe.getUrl());
                                xsw.writeCharacters(sqe.getSql());
                                xsw.writeEndElement();
                                xsw.writeCharacters(SQLHistoryManager.CONTENT_NEWLINE);
                            }
                            xsw.writeEndElement();
                            xsw.flush();
                            xsw.close();
                        }
                        catch (IOException | XMLStreamException ex) {
                            LOGGER.log(Level.INFO, ex.getMessage(), ex);
                        }
                        finally {
                            SQLHistoryManager.this.PROPERTY_CHANGE_SUPPORT.firePropertyChange(SQLHistoryManager.PROP_SAVED, null, null);
                        }
                    }
                });
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, ex.getMessage());
            }
        }
    }
}

