/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websocket.wizard;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class WebSocketVisual
extends JPanel {
    private JLabel myPathLbl;
    private JTextField myUri;
    private List<ChangeListener> myListeners;

    WebSocketVisual(WizardDescriptor myDescriptor) {
        this.initComponents();
        this.myUri.setText("/endpoint");
        this.myListeners = new CopyOnWriteArrayList<ChangeListener>();
    }

    void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    String getError() {
        if (this.myUri.getText().trim().length() == 0) {
            return NbBundle.getMessage(WebSocketVisual.class, (String)"ERR_EmptyUri");
        }
        return null;
    }

    void readSettings(WizardDescriptor descriptor) {
    }

    void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("websocket.uri", (Object)this.myUri.getText());
    }

    private void initComponents() {
        this.myPathLbl = new JLabel();
        this.myUri = new JTextField();
        this.myPathLbl.setLabelFor(this.myUri);
        Mnemonics.setLocalizedText((JLabel)this.myPathLbl, (String)NbBundle.getMessage(WebSocketVisual.class, (String)"LBL_URI"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myPathLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myUri, -1, 275, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myPathLbl).addComponent(this.myUri, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.myPathLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebSocketVisual.class, (String)"ACSN_URI"));
        this.myPathLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebSocketVisual.class, (String)"ACSD_URI"));
        this.myUri.getAccessibleContext().setAccessibleName(this.myPathLbl.getAccessibleContext().getAccessibleName());
        this.myUri.getAccessibleContext().setAccessibleDescription(this.myPathLbl.getAccessibleContext().getAccessibleDescription());
    }
}

