/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetViewValueNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GetViewValueNode.class)
public final class GetViewValueNodeGen
extends GetViewValueNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private GetData get_cache;

    private GetViewValueNodeGen(JSContext context, String type, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian) {
        super(context, type, view, requestIndex, isLittleEndian);
    }

    private GetViewValueNodeGen(JSContext context, TypedArrayFactory factory, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian) {
        super(context, factory, view, requestIndex, isLittleEndian);
    }

    @Override
    public Object execute(Object viewNodeValue, Object requestIndexNodeValue, Object isLittleEndianNodeValue) {
        GetData s1_;
        int state = this.state_;
        if (state != 0 && (s1_ = this.get_cache) != null) {
            return this.doGet(viewNodeValue, requestIndexNodeValue, isLittleEndianNodeValue, s1_.toIndexNode_, s1_.errorBranch_, s1_.typeProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(viewNodeValue, requestIndexNodeValue, isLittleEndianNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        GetData s1_;
        int state = this.state_;
        Object viewNodeValue_ = this.viewNode.execute(frameValue);
        Object requestIndexNodeValue_ = this.requestIndexNode.execute(frameValue);
        Object isLittleEndianNodeValue_ = this.isLittleEndianNode.execute(frameValue);
        if (state != 0 && (s1_ = this.get_cache) != null) {
            return this.doGet(viewNodeValue_, requestIndexNodeValue_, isLittleEndianNodeValue_, s1_.toIndexNode_, s1_.errorBranch_, s1_.typeProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(viewNodeValue_, requestIndexNodeValue_, isLittleEndianNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object viewNodeValue, Object requestIndexNodeValue, Object isLittleEndianNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            GetData s1_ = (GetData)super.insert((Node)new GetData());
            s1_.toIndexNode_ = s1_.insertAccessor(JSToIndexNode.create());
            s1_.errorBranch_ = BranchProfile.create();
            s1_.typeProfile_ = ValueProfile.createClassProfile();
            this.get_cache = s1_;
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            Object object = this.doGet(viewNodeValue, requestIndexNodeValue, isLittleEndianNodeValue, s1_.toIndexNode_, s1_.errorBranch_, s1_.typeProfile_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[2];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doGet";
        if (state != 0) {
            s[1] = (byte)1;
            ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
            GetData s1_ = this.get_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s1_.toIndexNode_, s1_.errorBranch_, s1_.typeProfile_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static GetViewValueNode create(JSContext context, String type, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian) {
        return new GetViewValueNodeGen(context, type, view, requestIndex, isLittleEndian);
    }

    public static GetViewValueNode create(JSContext context, TypedArrayFactory factory, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian) {
        return new GetViewValueNodeGen(context, factory, view, requestIndex, isLittleEndian);
    }

    @GeneratedBy(value=GetViewValueNode.class)
    private static final class GetData
    extends Node {
        @Node.Child
        JSToIndexNode toIndexNode_;
        @CompilerDirectives.CompilationFinal
        BranchProfile errorBranch_;
        @CompilerDirectives.CompilationFinal
        ValueProfile typeProfile_;

        GetData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

