/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.implspi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public abstract class SourceFactory {
    private static final SourceFactory DEFAULT_SOURCE_FACTORY = new DefaultSourceFactory();

    @NonNull
    public static SourceFactory getDefault() {
        SourceFactory sf = (SourceFactory)Lookup.getDefault().lookup(SourceFactory.class);
        if (sf == null) {
            sf = DEFAULT_SOURCE_FACTORY;
        }
        return sf;
    }

    @CheckForNull
    public abstract Source createSource(@NonNull FileObject var1, @NonNull String var2, @NonNull Lookup var3);

    @CheckForNull
    public abstract Source getSource(@NonNull FileObject var1);

    @CheckForNull
    public abstract Source removeSource(@NonNull FileObject var1);

    protected final Source newSource(@NonNull FileObject fo, @NonNull String mimeType, @NonNull Lookup context) {
        return SourceAccessor.getINSTANCE().create(fo, mimeType, context);
    }

    private static class DefaultSourceFactory
    extends SourceFactory {
        private final Map<FileObject, Reference<Source>> instances = new WeakHashMap<FileObject, Reference<Source>>();

        private DefaultSourceFactory() {
        }

        @Override
        public Source createSource(@NonNull FileObject file, @NonNull String mimeType, @NonNull Lookup context) {
            Source source;
            Parameters.notNull((CharSequence)"file", (Object)file);
            Parameters.notNull((CharSequence)"mimeType", (Object)mimeType);
            Parameters.notNull((CharSequence)"context", (Object)context);
            Reference<Source> sourceRef = this.instances.get(file);
            Source source2 = source = sourceRef == null ? null : sourceRef.get();
            if (source == null || !mimeType.equals(source.getMimeType())) {
                source = this.newSource(file, mimeType, context);
                this.instances.put(file, new WeakReference<Source>(source));
            }
            return source;
        }

        @Override
        public Source getSource(@NonNull FileObject file) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            Reference<Source> ref = this.instances.get(file);
            return ref == null ? null : ref.get();
        }

        @Override
        public Source removeSource(@NonNull FileObject file) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            Reference<Source> ref = this.instances.remove(file);
            return ref == null ? null : ref.get();
        }
    }
}

