/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.config.AbstractListenerContainerParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class JcaListenerContainerParser
extends AbstractListenerContainerParser {
    private static final String RESOURCE_ADAPTER_ATTRIBUTE = "resource-adapter";
    private static final String ACTIVATION_SPEC_FACTORY_ATTRIBUTE = "activation-spec-factory";

    JcaListenerContainerParser() {
    }

    protected BeanDefinition parseContainer(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String phase;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition();
        containerDef.setSource(parserContext.extractSource((Object)containerEle));
        containerDef.setBeanClassName("org.springframework.jms.listener.endpoint.JmsMessageEndpointManager");
        if (containerEle.hasAttribute(RESOURCE_ADAPTER_ATTRIBUTE)) {
            String resourceAdapterBeanName = containerEle.getAttribute(RESOURCE_ADAPTER_ATTRIBUTE);
            if (!StringUtils.hasText((String)resourceAdapterBeanName)) {
                parserContext.getReaderContext().error("Listener container 'resource-adapter' attribute contains empty value.", (Object)containerEle);
            } else {
                containerDef.getPropertyValues().add("resourceAdapter", (Object)new RuntimeBeanReference(resourceAdapterBeanName));
            }
        }
        String activationSpecFactoryBeanName = containerEle.getAttribute(ACTIVATION_SPEC_FACTORY_ATTRIBUTE);
        String destinationResolverBeanName = containerEle.getAttribute("destination-resolver");
        if (StringUtils.hasText((String)activationSpecFactoryBeanName)) {
            if (StringUtils.hasText((String)destinationResolverBeanName)) {
                parserContext.getReaderContext().error("Specify either 'activation-spec-factory' or 'destination-resolver', not both. If you define a dedicated JmsActivationSpecFactory bean, specify the custom DestinationResolver there (if possible).", (Object)containerEle);
            }
            containerDef.getPropertyValues().add("activationSpecFactory", (Object)new RuntimeBeanReference(activationSpecFactoryBeanName));
        }
        if (StringUtils.hasText((String)destinationResolverBeanName)) {
            containerDef.getPropertyValues().add("destinationResolver", (Object)new RuntimeBeanReference(destinationResolverBeanName));
        }
        RootBeanDefinition configDef = new RootBeanDefinition();
        configDef.setSource(parserContext.extractSource((Object)configDef));
        configDef.setBeanClassName("org.springframework.jms.listener.endpoint.JmsActivationSpecConfig");
        this.parseListenerConfiguration(listenerEle, parserContext, (BeanDefinition)configDef);
        this.parseContainerConfiguration(containerEle, parserContext, (BeanDefinition)configDef);
        Integer acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext);
        if (acknowledgeMode != null) {
            configDef.getPropertyValues().add("acknowledgeMode", (Object)acknowledgeMode);
        }
        if (StringUtils.hasText((String)(transactionManagerBeanName = containerEle.getAttribute("transaction-manager")))) {
            containerDef.getPropertyValues().add("transactionManager", (Object)new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText((String)(concurrency = containerEle.getAttribute("concurrency")))) {
            configDef.getPropertyValues().add("concurrency", (Object)concurrency);
        }
        if (StringUtils.hasText((String)(prefetch = containerEle.getAttribute("prefetch")))) {
            configDef.getPropertyValues().add("prefetchSize", (Object)Integer.valueOf(prefetch));
        }
        if (StringUtils.hasText((String)(phase = containerEle.getAttribute("phase")))) {
            containerDef.getPropertyValues().add("phase", (Object)phase);
        }
        containerDef.getPropertyValues().add("activationSpecConfig", (Object)configDef);
        return containerDef;
    }

    protected boolean indicatesPubSub(BeanDefinition containerDef) {
        BeanDefinition configDef = (BeanDefinition)containerDef.getPropertyValues().getPropertyValue("activationSpecConfig").getValue();
        return this.indicatesPubSubConfig(configDef);
    }
}

