/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.modules.editor.search.ReplaceBar;
import org.netbeans.modules.editor.search.SearchBar;
import org.netbeans.spi.editor.SideBarFactory;

public final class SearchNbEditorKit
extends NbEditorKit {
    public static final String REPLACE_ACTION = "replace";
    public static final String SEARCH_ACTION = "find";
    public static final String SEARCHBAR_MIMETYPE = "text/x-editor-search";
    public static final String PROP_SEARCH_CONTAINER = "diff.search.container";
    private static PropertyChangeListener searchAndReplaceBarPersistentListener = null;

    public static <T> T findComponent(Container container, Class<T> componentClass, int depth) {
        if (depth > 0) {
            for (Component c : container.getComponents()) {
                T target;
                if (componentClass.isAssignableFrom(c.getClass())) {
                    return (T)c;
                }
                if (!(c instanceof Container) || (target = SearchNbEditorKit.findComponent((Container)c, componentClass, depth - 1)) == null) continue;
                return target;
            }
        }
        return null;
    }

    public String getContentType() {
        return SEARCHBAR_MIMETYPE;
    }

    public static synchronized void makeSearchAndReplaceBarPersistent() {
        if (searchAndReplaceBarPersistentListener == null) {
            searchAndReplaceBarPersistentListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("focusGained") && SearchBar.getInstance().getActualTextComponent() != EditorRegistry.lastFocusedComponent() && SearchBar.getInstance().isVisible()) {
                        JTextComponent target = EditorRegistry.lastFocusedComponent();
                        JPanel jp = null;
                        Object clientProperty = target.getClientProperty(SearchNbEditorKit.PROP_SEARCH_CONTAINER);
                        if (clientProperty instanceof JPanel) {
                            jp = (JPanel)clientProperty;
                        } else {
                            EditorUI eui = Utilities.getEditorUI((JTextComponent)target);
                            if (eui != null) {
                                JComponent comp;
                                JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                                if (comp != null) {
                                    jp = SearchNbEditorKit.findComponent(comp, SearchJPanel.class, 5);
                                }
                            }
                        }
                        if (jp != null) {
                            SearchBar searchBarInstance = SearchBar.getInstance(target);
                            ReplaceBar replaceBarInstance = ReplaceBar.getInstance(searchBarInstance);
                            jp.add(searchBarInstance);
                            if (replaceBarInstance.isVisible()) {
                                jp.add(replaceBarInstance);
                            }
                            jp.revalidate();
                            searchBarInstance.checkRegainFocus(evt);
                        }
                    } else if ("focusLost".equals(evt.getPropertyName())) {
                        SearchBar.getInstance().notifyFocusLost(evt);
                    }
                }
            };
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)searchAndReplaceBarPersistentListener);
        }
    }

    public static void openFindIfNecessary(JTextComponent component, ActionEvent evt) {
        Action findAction;
        Object findWhat = EditorFindSupport.getInstance().getFindProperty("find-what");
        if ((findWhat == null || !(findWhat instanceof String) || ((String)findWhat).isEmpty()) && (findAction = ((BaseKit)component.getUI().getEditorKit(component)).getActionByName(SEARCH_ACTION)) != null) {
            findAction.actionPerformed(evt);
        }
    }

    public static class SearchJPanel
    extends JPanel {
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            SearchJPanel searchJPanel = new SearchJPanel();
            searchJPanel.setLayout(new BoxLayout(searchJPanel, 1));
            return searchJPanel;
        }
    }
}

