/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;

public class LibraryUtils {
    public static final String COMPOSITE_LIBRARY_NS = "http://xmlns.jcp.org/jsf/composite";
    public static final String COMPOSITE_LIBRARY_LEGACY_NS = "http://java.sun.com/jsf/composite";
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    public static String getCompositeLibraryURL(String libraryFolderPath, boolean jsf22Plus) {
        if (jsf22Plus) {
            return "http://xmlns.jcp.org/jsf/composite/" + libraryFolderPath;
        }
        return "http://java.sun.com/jsf/composite/" + libraryFolderPath;
    }

    @Deprecated
    public static boolean isCompositeComponentLibrary(Library library) {
        return library.getType() == LibraryType.COMPOSITE;
    }

    public static boolean importLibrary(Document document, Library library, String prefix, boolean isJsf22Plus) {
        return !LibraryUtils.importLibrary(document, Collections.singletonMap(library, prefix), isJsf22Plus).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Library, String> importLibrary(Document document, Map<Library, String> libraries2prefixes, final boolean isJsf22Plus) {
        assert (document instanceof BaseDocument);
        final LinkedHashMap<Library, String> imports = new LinkedHashMap<Library, String>(libraries2prefixes);
        Iterator libsIterator = imports.keySet().iterator();
        while (libsIterator.hasNext()) {
            Library l = (Library)libsIterator.next();
            String prefix = (String)imports.get(l);
            if (prefix != null) continue;
            String defaultPrefix = l.getDefaultPrefix();
            if (defaultPrefix != null) {
                imports.put(l, defaultPrefix);
                continue;
            }
            libsIterator.remove();
        }
        final BaseDocument bdoc = (BaseDocument)document;
        try {
            Source source = Source.create((Document)bdoc);
            final HtmlParsingResult[] _result = new HtmlParsingResult[1];
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (ri != null) {
                        _result[0] = (HtmlParsingResult)ri.getParserResult();
                    }
                }
            });
            if (_result[0] == null) {
                return Collections.emptyMap();
            }
            final HtmlParsingResult result = _result[0];
            Element root = null;
            ArrayList<Object> roots = new ArrayList<Object>();
            roots.addAll(result.roots().values());
            roots.add(result.rootOfUndeclaredTagsParseTree());
            for (Node node : roots) {
                Collection chs = node.children(new ElementFilter(){

                    public boolean accepts(Element node) {
                        if (node.type() == ElementType.OPEN_TAG) {
                            OpenTag openTag = (OpenTag)node;
                            return !openTag.isEmpty() && !ElementUtils.isVirtualNode((Element)node);
                        }
                        return false;
                    }
                });
                ArrayList chsList = new ArrayList(chs);
                if (chsList.isEmpty()) continue;
                Element top = (Element)chsList.get(0);
                if (root == null) {
                    root = top;
                    continue;
                }
                if (top.from() >= root.to()) continue;
                root = top;
            }
            final Element rootNode = root;
            if (rootNode == null) {
                return Collections.emptyMap();
            }
            Iterator iterator = imports.keySet().iterator();
            while (iterator.hasNext()) {
                Library library = (Library)iterator.next();
                Map declaredNamespaces = result.getNamespaces();
                String alreadyDeclaredPrefix = (String)NamespaceUtils.getForNs(declaredNamespaces, library.getNamespace());
                if (alreadyDeclaredPrefix == null) {
                    String defaultNS = library.getDefaultNamespace();
                    alreadyDeclaredPrefix = (String)declaredNamespaces.get(defaultNS);
                }
                if (alreadyDeclaredPrefix == null) continue;
                iterator.remove();
            }
            final Indent indent = Indent.get((Document)bdoc);
            indent.lock();
            try {
                bdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OpenTag ot = (OpenTag)rootNode;
                            boolean noAttributes = ot.attributes().isEmpty();
                            int offset_shift = 0;
                            Iterator libsItr = imports.keySet().iterator();
                            Parser.Result parsingApiResult = (Parser.Result)result;
                            int originalInsertPosition = parsingApiResult.getSnapshot().getOriginalOffset(rootNode.to() - 1);
                            if (originalInsertPosition == -1) {
                                imports.clear();
                                return;
                            }
                            while (libsItr.hasNext()) {
                                Library library = (Library)libsItr.next();
                                String prefixToDeclare = (String)imports.get(library);
                                int insertPosition = originalInsertPosition + offset_shift;
                                String namespace = isJsf22Plus || library.getLegacyNamespace() == null ? library.getNamespace() : library.getLegacyNamespace();
                                String text = (!noAttributes ? "\n" : "") + " xmlns:" + prefixToDeclare + "=\"" + namespace + "\"";
                                bdoc.insertString(insertPosition, text, null);
                                offset_shift += text.length();
                            }
                            indent.reindent(originalInsertPosition, originalInsertPosition + offset_shift);
                        }
                        catch (BadLocationException ex) {
                            Logger.getAnonymousLogger().log(Level.INFO, null, ex);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
            return imports;
        }
        catch (ParseException ex) {
            Logger.getAnonymousLogger().log(Level.INFO, null, ex);
            return Collections.emptyMap();
        }
    }

    public static Map<String, Library> getDeclaredLibraries(HtmlParsingResult result) {
        Set declaredNamespaces = result.getNamespaces().keySet();
        HashMap<String, Library> declaredLibraries = new HashMap<String, Library>();
        JsfSupport jsfSupport = JsfSupportProvider.get(result.getSyntaxAnalyzerResult().getSource().getSourceFileObject());
        if (jsfSupport != null) {
            Map<String, ? extends Library> libs = jsfSupport.getLibraries();
            for (String namespace : declaredNamespaces) {
                Library lib = NamespaceUtils.getForNs(libs, namespace);
                if (lib == null) continue;
                declaredLibraries.put(namespace, lib);
            }
        }
        return declaredLibraries;
    }

    @NonNull
    public static String generateDefaultPrefix(@NonNull String namespace) {
        String[] tokens;
        String HTTP_PREFIX = "http://";
        if (namespace.startsWith("http://")) {
            namespace = namespace.substring("http://".length());
        }
        if ((tokens = namespace.split("[/.]")).length == 0) {
            return "lib";
        }
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            sb.append(token.charAt(0));
        }
        return sb.toString();
    }

    public static Project[] getOpenedJSFProjects() {
        return JsfSupportProvider.CACHE.keySet().toArray(new Project[0]);
    }
}

