/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.execute;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.actions.AfterBuildActionHook;
import org.netbeans.modules.gradle.spi.actions.BeforeBuildActionHook;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class DebugFixHooks
implements BeforeBuildActionHook,
AfterBuildActionHook {
    final Project project;

    public DebugFixHooks(Project project) {
        this.project = project;
    }

    public Lookup beforeAction(String action, Lookup context, PrintWriter out) {
        if ("debug.fix".equals(action)) {
            Set<GradleJavaSourceSet> sourceSets = this.affectedSourceSets(this.fetchFilesToReload(context));
            StringBuilder classesTasks = new StringBuilder();
            String delim = "";
            for (GradleJavaSourceSet sourceSet : sourceSets) {
                classesTasks.append(delim).append(sourceSet.getClassesTaskName());
                delim = " ";
            }
        }
        return context;
    }

    public void afterAction(String action, Lookup context, int result, PrintWriter out) {
        if ("debug.fix".equals(action) && result == 0) {
            GradleJavaProject jp = GradleJavaProject.get(this.project);
            out.println();
            for (FileObject fo : this.fetchFilesToReload(context)) {
                GradleJavaSourceSet ss = jp.containingSourceSet(FileUtil.toFile((FileObject)fo));
                String pkg = null;
                for (File dir : ss.getAvailableDirs()) {
                    FileObject foDir = FileUtil.toFileObject((File)dir);
                    if (!FileUtil.isParentOf((FileObject)foDir, (FileObject)fo)) continue;
                    pkg = FileUtil.getRelativePath((FileObject)foDir, (FileObject)fo.getParent()).replace('/', '.');
                    break;
                }
                String cname = pkg + '.' + fo.getName();
                this.applyChanges(out, ss, cname);
            }
        }
    }

    private void applyChanges(PrintWriter logger, GradleJavaSourceSet sourceSet, String classname) {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            logger.println("NetBeans: No debugging sessions was found.");
            return;
        }
        JPDADebugger debugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            logger.println("NetBeans: Current debugger is not JPDA one.");
            return;
        }
        if (!debugger.canFixClasses()) {
            logger.println("NetBeans: The debugger does not support Fix action.");
            return;
        }
        if (debugger.getState() == 4) {
            logger.println("NetBeans: The debugger is not running");
            return;
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
        String clazz = classname.replace('.', '/') + ".class";
        FileObject fo2 = FileUtil.toFileObject((File)sourceSet.findResource(clazz));
        if (fo2 != null) {
            try {
                String basename = fo2.getName();
                for (FileObject classfile : fo2.getParent().getChildren()) {
                    String basename2 = classfile.getName();
                    if (!"class".equals(classfile.getExt()) || !basename2.equals(basename) && !basename2.startsWith((String)basename + '$')) continue;
                    String url = DebugFixHooks.classToSourceURL(classfile, logger);
                    if (url != null) {
                        editorContext.updateTimeStamp((Object)debugger, url);
                    }
                    map.put(classname + basename2.substring(basename.length()), classfile.asBytes());
                }
            }
            catch (IOException basename) {
                // empty catch block
            }
        }
        if (map.isEmpty()) {
            logger.println("NetBeans: No class to reload");
            return;
        }
        logger.println("NetBeans: classes to reload: ");
        for (String cls : map.keySet()) {
            logger.println("    " + cls);
        }
        String error = null;
        try {
            debugger.fixClasses(map);
        }
        catch (UnsupportedOperationException uoex) {
            error = "The virtual machine does not support this operation: " + uoex.getLocalizedMessage();
        }
        catch (NoClassDefFoundError ncdfex) {
            error = "The bytes don't correspond to the class type (the names don't match): " + ncdfex.getLocalizedMessage();
        }
        catch (VerifyError ver) {
            error = "A \"verifier\" detects that a class, though well formed, contains an internal inconsistency or security problem: " + ver.getLocalizedMessage();
        }
        catch (UnsupportedClassVersionError ucver) {
            error = "The major and minor version numbers in bytes are not supported by the VM. " + ucver.getLocalizedMessage();
        }
        catch (ClassFormatError cfer) {
            error = "The bytes do not represent a valid class. " + cfer.getLocalizedMessage();
        }
        catch (ClassCircularityError ccer) {
            error = "A circularity has been detected while initializing a class: " + ccer.getLocalizedMessage();
        }
        if (error != null) {
            logger.println("NetBeans:" + error);
        } else {
            logger.println("Code Updated.");
        }
    }

    private static String classToSourceURL(FileObject fo, PrintWriter logger) {
        FileObject[] sRoots;
        ClassPath sourcePath;
        FileObject rfo;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(fo);
        String resourceName = cp.getResourceName(fo, '/', false);
        if (resourceName == null || root == null) {
            logger.println("Can not find classpath resource for " + fo + ", skipping...");
            return null;
        }
        int i = resourceName.indexOf(36);
        if (i > 0) {
            resourceName = resourceName.substring(0, i);
        }
        if ((rfo = (sourcePath = ClassPathSupport.createClassPath((FileObject[])(sRoots = SourceForBinaryQuery.findSourceRoots((URL)root.toURL()).getRoots()))).findResource(resourceName + ".java")) == null) {
            return null;
        }
        return rfo.toURL().toExternalForm();
    }

    private Set<GradleJavaSourceSet> affectedSourceSets(Set<FileObject> files) {
        GradleJavaProject jp = GradleJavaProject.get(this.project);
        HashSet<GradleJavaSourceSet> ret = new HashSet<GradleJavaSourceSet>();
        if (jp != null) {
            for (FileObject fo : files) {
                GradleJavaSourceSet ss = jp.containingSourceSet(FileUtil.toFile((FileObject)fo));
                if (ss == null) continue;
                ret.add(ss);
            }
        }
        return ret;
    }

    private Set<FileObject> fetchFilesToReload(Lookup context) {
        LinkedHashSet<FileObject> ret = new LinkedHashSet<FileObject>();
        ret.addAll(context.lookupAll(FileObject.class));
        for (DataObject data : context.lookupAll(DataObject.class)) {
            ret.add(data.getPrimaryFile());
        }
        return ret;
    }
}

