/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.HttpMethodsChildren;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class HttpMethodsNode
extends AbstractNode {
    private static final Image HTTP_METHODS_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/httpmethods.png", (boolean)true);
    static Icon folderIconCache;
    static Icon openedFolderIconCache;

    public HttpMethodsNode(Project project, RestServicesModel model, String serviceName) {
        super(Children.create((ChildFactory)new HttpMethodsChildren(project, model, serviceName), (boolean)true));
        this.setDisplayName(NbBundle.getBundle(HttpMethodsNode.class).getString("LBL_HttpMethods"));
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = HttpMethodsNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)HTTP_METHODS_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

