/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletion;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.php.editor.sql.DatabaseConnectionSupport;
import org.netbeans.modules.php.editor.sql.PHPSQLStatement;
import org.netbeans.modules.php.editor.sql.SelectConnectionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.text.NbDocument;

public class PHPSQLCompletion
implements CompletionProvider {
    private static final Boolean NO_COMPLETION = Boolean.getBoolean("netbeans.php.nosqlcompletion");

    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Query() {
        }

        protected void query(CompletionResultSet resultSet, Document document, int caretOffset) {
            this.doQuery(resultSet, document, caretOffset);
            resultSet.finish();
        }

        private void doQuery(CompletionResultSet resultSet, Document document, int caretOffset) {
            if (NO_COMPLETION.booleanValue()) {
                return;
            }
            PHPSQLStatement stmt = PHPSQLStatement.computeSQLStatement(document, caretOffset);
            if (stmt == null) {
                return;
            }
            SQLCompletionContext context = SQLCompletionContext.empty();
            if (!SQLCompletion.canComplete((SQLCompletionContext)(context = context.setStatement((CharSequence)stmt.getStatement())))) {
                return;
            }
            context = context.setOffset(stmt.sourceToGeneratedPos(caretOffset));
            DatabaseConnection dbconn = DatabaseConnectionSupport.getDatabaseConnection(document, true);
            if (dbconn == null) {
                resultSet.addItem((CompletionItem)new SelectConnectionItem(document));
            } else {
                context = context.setDatabaseConnection(dbconn);
                SQLCompletion completion = SQLCompletion.create((SQLCompletionContext)context);
                SQLCompletionResultSet sqlResultSet = SQLCompletionResultSet.create();
                completion.query(sqlResultSet, (SubstitutionHandler)new SQLSubstitutionHandler(stmt));
                resultSet.addAllItems((Collection)sqlResultSet.getItems());
                resultSet.setAnchorOffset(stmt.generatedToSourcePos(sqlResultSet.getAnchorOffset()));
            }
        }

        static class SQLSubstitutionHandler
        implements SubstitutionHandler {
            final PHPSQLStatement statement;

            public SQLSubstitutionHandler(PHPSQLStatement statement) {
                this.statement = statement;
            }

            public void substituteText(JTextComponent component, int offset, final String text) {
                final int caretOffset = component.getSelectionEnd();
                final int sourceOffset = this.statement.generatedToSourcePos(offset);
                final StyledDocument document = (StyledDocument)component.getDocument();
                try {
                    NbDocument.runAtomicAsUser((StyledDocument)document, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int documentOffset = sourceOffset;
                                document.remove(documentOffset, caretOffset - documentOffset);
                                document.insertString(documentOffset, text, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

