/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum Distribution implements ApiFeature
{
    AOJ("AOJ", "aoj"),
    AOJ_OPENJ9("AOJ OpenJ9", "aoj_openj9"),
    CORRETTO("Corretto", "corretto"),
    DRAGONWELL("Dragonwell", "dragonwell"),
    GRAALVM_CE8("Graal VM CE 8", "graalvm_ce8"),
    GRAALVM_CE11("Graal VM CE 11", "graalvm_ce11"),
    GRAALVM_CE16("Graal VM CE 16", "graalvm_ce16"),
    LIBERICA("Liberica", "liberica"),
    LIBERICA_NATIVE("Liberica Native", "liberica_native"),
    MANDREL("Mandrel", "mandrel"),
    MICROSOFT("Microsoft", "microsoft"),
    OJDK_BUILD("OJDKBuild", "ojdk_build"),
    OPEN_LOGIC("OpenLogic", "openlogic"),
    ORACLE("Oracle", "oracle"),
    ORACLE_OPEN_JDK("Oracle OpenJDK", "oracle_openjdk"),
    RED_HAT("Red Hat", "redhat"),
    SAP_MACHINE("SAP Machine", "sapmachine"),
    TEMURIN("Temurin", "temurin"),
    TRAVA("Trava", "trava"),
    ZULU("Zulu", "zulu"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Distribution(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Distribution getDefault() {
        return NONE;
    }

    @Override
    public Distribution getNotFound() {
        return NOT_FOUND;
    }

    public Distribution[] getAll() {
        return Distribution.values();
    }

    public static Distribution fromText(String text) {
        switch (text) {
            case "temurin": 
            case "Temurin": 
            case "TEMURIN": {
                return TEMURIN;
            }
            case "aoj": 
            case "AOJ": {
                return AOJ;
            }
            case "aoj_openj9": 
            case "AOJ_OpenJ9": 
            case "AOJ_OPENJ9": 
            case "AOJ OpenJ9": 
            case "AOJ OPENJ9": 
            case "aoj openj9": {
                return AOJ_OPENJ9;
            }
            case "corretto": 
            case "CORRETTO": 
            case "Corretto": {
                return CORRETTO;
            }
            case "dragonwell": 
            case "DRAGONWELL": 
            case "Dragonwell": {
                return DRAGONWELL;
            }
            case "liberica": 
            case "LIBERICA": 
            case "Liberica": {
                return LIBERICA;
            }
            case "liberica_native": 
            case "LIBERICA_NATIVE": 
            case "libericaNative": 
            case "LibericaNative": 
            case "liberica native": 
            case "LIBERICA NATIVE": 
            case "Liberica Native": {
                return LIBERICA_NATIVE;
            }
            case "mandrel": 
            case "MANDREL": 
            case "Mandrel": {
                return MANDREL;
            }
            case "microsoft": 
            case "Microsoft": 
            case "MICROSOFT": 
            case "Microsoft Build of OpenJDK": {
                return MICROSOFT;
            }
            case "graalvm_ce8": 
            case "graalvmce8": 
            case "GraalVM CE 8": 
            case "GraalVMCE8": 
            case "GraalVM_CE8": {
                return GRAALVM_CE8;
            }
            case "graalvm_ce11": 
            case "graalvmce11": 
            case "GraalVM CE 11": 
            case "GraalVMCE11": 
            case "GraalVM_CE11": {
                return GRAALVM_CE11;
            }
            case "graalvm_ce16": 
            case "graalvmce16": 
            case "GraalVM CE 16": 
            case "GraalVMCE16": 
            case "GraalVM_CE16": {
                return GRAALVM_CE16;
            }
            case "sap_machine": 
            case "sapmachine": 
            case "SAPMACHINE": 
            case "SAP_MACHINE": 
            case "SAPMachine": 
            case "SAP Machine": 
            case "sap-machine": 
            case "SAP-Machine": 
            case "SAP-MACHINE": {
                return SAP_MACHINE;
            }
            case "trava": 
            case "TRAVA": 
            case "trava_openjdk": 
            case "TRAVA_OPENJDK": 
            case "trava openjdk": 
            case "TRAVA OPENJDK": {
                return TRAVA;
            }
            case "zulu": 
            case "ZULU": 
            case "Zulu": {
                return ZULU;
            }
            case "oracle_open_jdk": 
            case "ORACLE_OPEN_JDK": 
            case "oracle_openjdk": 
            case "ORACLE_OPENJDK": 
            case "Oracle_OpenJDK": 
            case "Oracle OpenJDK": 
            case "oracle openjdk": 
            case "ORACLE OPENJDK": 
            case "open_jdk": 
            case "openjdk": 
            case "OpenJDK": 
            case "Open JDK": 
            case "OPEN_JDK": 
            case "open-jdk": 
            case "OPEN-JDK": 
            case "Oracle-OpenJDK": 
            case "oracle-openjdk": 
            case "ORACLE-OPENJDK": 
            case "oracle-open-jdk": 
            case "ORACLE-OPEN-JDK": {
                return ORACLE_OPEN_JDK;
            }
            case "oracle": 
            case "Oracle": 
            case "ORACLE": {
                return ORACLE;
            }
            case "RedHat": 
            case "redhat": 
            case "REDHAT": 
            case "Red Hat": 
            case "red hat": 
            case "RED HAT": 
            case "Red_Hat": 
            case "red_hat": 
            case "red-hat": 
            case "Red-Hat": 
            case "RED-HAT": {
                return RED_HAT;
            }
            case "ojdk_build": 
            case "OJDK_BUILD": 
            case "ojdkbuild": 
            case "OJDKBuild": {
                return OJDK_BUILD;
            }
            case "openlogic": 
            case "OPENLOGIC": 
            case "OpenLogic": 
            case "open_logic": 
            case "OPEN_LOGIC": {
                return OPEN_LOGIC;
            }
        }
        return NOT_FOUND;
    }

    public static List<Distribution> getDistributions() {
        return Arrays.stream(Distribution.values()).filter(distro -> NONE != distro && NOT_FOUND != distro).collect(Collectors.toList());
    }

    public static List<Distribution> getAsList() {
        return Arrays.asList(Distribution.values());
    }

    public static List<Distribution> getDistributionsBasedOnOpenJDK() {
        return Arrays.stream(Distribution.values()).filter(distribution -> NONE != distribution).filter(distribution -> NOT_FOUND != distribution).filter(distribution -> GRAALVM_CE11 != distribution).filter(distribution -> GRAALVM_CE8 != distribution).filter(distribution -> MANDREL != distribution).filter(distribution -> LIBERICA_NATIVE != distribution).collect(Collectors.toList());
    }

    public static List<Distribution> getDistributionsBasedOnGraalVm() {
        return Arrays.stream(Distribution.values()).filter(distribution -> NONE == distribution).filter(distribution -> NOT_FOUND == distribution).filter(distribution -> GRAALVM_CE11 == distribution).filter(distribution -> GRAALVM_CE8 == distribution).filter(distribution -> MANDREL == distribution).filter(distribution -> LIBERICA_NATIVE == distribution).collect(Collectors.toList());
    }
}

