/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PropertyManager {
    INSTANCE;

    private static final Logger LOGGER;
    private static final String PROPERTIES_FILE_NAME = "discoclient.properties";
    private Properties properties = new Properties();

    private PropertyManager() {
        String propFilePath = System.getProperty("user.home") + File.separator + PROPERTIES_FILE_NAME;
        Path path = Paths.get(propFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.createProperties(this.properties);
        }
        try (FileInputStream propFile = new FileInputStream(propFilePath);){
            this.properties.load(propFile);
        }
        catch (IOException ex) {
            System.out.println("Error reading properties file. " + ex);
        }
        if (this.properties.isEmpty()) {
            this.createProperties(this.properties);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(String KEY) {
        return this.properties.getOrDefault((Object)KEY, "");
    }

    public void set(String KEY, String VALUE) {
        this.properties.setProperty(KEY, VALUE);
        try {
            this.properties.store(new FileOutputStream(String.join((CharSequence)File.separator, System.getProperty("user.dir"), PROPERTIES_FILE_NAME)), null);
        }
        catch (IOException exception) {
            System.out.println("Error writing properties file: " + exception);
        }
    }

    public String getString(String key) {
        return this.properties.getOrDefault((Object)key, "").toString();
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public int getInt(String key) {
        return Integer.parseInt(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public long getLong(String key) {
        return Long.parseLong(this.properties.getOrDefault((Object)key, "0").toString());
    }

    private void createProperties(Properties properties) {
        String propFilePath = System.getProperty("user.home") + File.separator + PROPERTIES_FILE_NAME;
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            properties.put("url", "https://api.foojay.io");
            properties.store(output, null);
        }
        catch (IOException ex) {
            LOGGER.debug("Error creating {} file: {}", (Object)PROPERTIES_FILE_NAME, (Object)ex.getMessage());
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(PropertyManager.class);
    }
}

