/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.nativeimage.debugger.actions.Bundle;
import org.netbeans.modules.java.nativeimage.debugger.api.NIDebugRunner;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NIAttachCustomizer
extends JPanel {
    private final ConnectController controller;
    private final ValidityDocumentListener validityDocumentListener = new ValidityDocumentListener();
    private final RequestProcessor currentFileRP = new RequestProcessor(NIAttachCustomizer.class);
    private JComboBox<String> dbgComboBox;
    private JLabel dbgLabel;
    private JButton fileButton;
    private JLabel fileLabel;
    private JTextField fileTextField;
    RequestProcessor.Task validationTask = this.currentFileRP.create((Runnable)new FileValidationTask());
    private static final String CPPLITE_DEBUGGER = "org.netbeans.modules.cpplite.debugger";

    public NIAttachCustomizer() {
        this.controller = new ConnectController();
        this.initComponents();
        this.fileTextField.getDocument().addDocumentListener(this.validityDocumentListener);
        this.initNIFile();
    }

    private void initNIFile() {
        this.currentFileRP.post(() -> {
            FileObject currentFO = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (currentFO != null) {
                String path;
                File currentFile = FileUtil.toFile((FileObject)currentFO);
                if (currentFile != null && currentFile.canExecute()) {
                    path = currentFile.getAbsolutePath();
                } else {
                    Project project = FileOwnerQuery.getOwner((FileObject)currentFO);
                    if (project != null) {
                        currentFO = project.getProjectDirectory();
                        currentFile = FileUtil.toFile((FileObject)currentFO);
                        path = currentFile.getAbsolutePath();
                    } else {
                        path = null;
                    }
                }
                if (path != null) {
                    SwingUtilities.invokeLater(() -> this.fileTextField.setText(path));
                }
            }
        });
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.fileButton = new JButton();
        this.dbgLabel = new JLabel();
        this.dbgComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.fileLabel.text"));
        this.fileTextField.setText(NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.fileTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.fileButton.text"));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NIAttachCustomizer.this.fileButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.dbgLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.dbgLabel.text"));
        this.dbgComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"gdb", "lldb-mi"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTextField)).addGroup(layout.createSequentialGroup().addComponent(this.dbgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbgComboBox, 0, 196, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.fileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbgLabel).addComponent(this.dbgComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.fileTextField.getText());
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.canExecute();
            }

            @Override
            public String getDescription() {
                return Bundle.CTL_ExecutableFiles();
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            this.fileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void checkValid() {
        assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
        if (this.fileTextField.getText().isEmpty()) {
            this.controller.setInformationMessage(Bundle.MSG_NoFile());
            this.controller.setValid(false);
            return;
        }
        this.validationTask.schedule(200);
    }

    Controller getController() {
        return this.controller;
    }

    private static boolean checkCPPLite() {
        ModuleInfo cppliteDebugger = Modules.getDefault().findCodeNameBase(CPPLITE_DEBUGGER);
        if (cppliteDebugger != null && !cppliteDebugger.isEnabled()) {
            Action pluginsManager = Actions.forID((String)"System", (String)"org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction");
            String moduleDisplayName = cppliteDebugger.getDisplayName();
            NotifyDescriptor.Confirmation messageDescriptor = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_EnableNativeDebugger(moduleDisplayName), Bundle.TTL_EnableNativeDebugger(), 2);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)messageDescriptor))) {
                SwingUtilities.invokeLater(() -> {
                    ActionEvent ev = new ActionEvent(pluginsManager, 100, "installed");
                    pluginsManager.actionPerformed(ev);
                });
            }
            return false;
        }
        return true;
    }

    public class ConnectController
    implements PersistentController {
        private static final String NI_ATTACH_PROPERTIES = "native_image_attach_settings";
        private static final String PROP_NI_FILE = "niFile";
        private static final String PROP_DBG = "debugger";
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public String getDisplayName() {
            return NIAttachCustomizer.this.dbgComboBox.getSelectedItem() + " " + new File(NIAttachCustomizer.this.fileTextField.getText()).getName();
        }

        public boolean load(Properties props) {
            assert (!SwingUtilities.isEventDispatchThread());
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        NIAttachCustomizer.this.fileTextField.setText(attachProps.getString(ConnectController.PROP_NI_FILE, ""));
                        NIAttachCustomizer.this.dbgComboBox.setSelectedItem(attachProps.getString(ConnectController.PROP_DBG, "DBG"));
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        public void save(Properties props) {
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            if (SwingUtilities.isEventDispatchThread()) {
                this.saveToProps(attachProps);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ConnectController.this.saveToProps(attachProps);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void saveToProps(Properties attachProps) {
            attachProps.setString(PROP_NI_FILE, NIAttachCustomizer.this.fileTextField.getText());
            attachProps.setString(PROP_DBG, (String)NIAttachCustomizer.this.dbgComboBox.getSelectedItem());
        }

        public boolean ok() {
            String filePath = NIAttachCustomizer.this.fileTextField.getText();
            String debuggerCommand = NIAttachCustomizer.this.dbgComboBox.getSelectedItem().toString();
            NIAttachCustomizer.this.currentFileRP.post(() -> {
                if (!NIAttachCustomizer.checkCPPLite()) {
                    return;
                }
                File file = new File(filePath);
                String displayName = "debug " + file.getName();
                NIDebugRunner.start(file, Collections.emptyList(), debuggerCommand, null, displayName, null, null);
            });
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
            this.firePropertyChange("valid", !valid, valid);
        }

        void setErrorMessage(String msg) {
            this.firePropertyChange("errorNotification", null, msg);
        }

        void setInformationMessage(String msg) {
            this.firePropertyChange("infoNotification", null, msg);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }
    }

    private class FileValidationTask
    implements Runnable {
        private FileValidationTask() {
        }

        @Override
        public void run() {
            String filePath = NIAttachCustomizer.this.fileTextField.getText();
            File file = new File(filePath);
            boolean canExecute = file.isFile() && file.canExecute();
            SwingUtilities.invokeLater(() -> {
                NIAttachCustomizer.this.controller.setValid(canExecute);
                String message = canExecute ? null : Bundle.MSG_NoFile();
                NIAttachCustomizer.this.controller.setInformationMessage(message);
            });
        }
    }
}

