/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.StringTools;

public class ManualTagger
implements WordTagger {
    private static final String DEFAULT_SEPARATOR = "\t";
    private static final int OFFSET_SHIFT = 8;
    private static final int MAX_LENGTH = 255;
    private static final int MAX_OFFSET = 0xFFFFFF;
    private static final int ENTRY_SIZE = 2;
    private final String[] data;
    private final TObjectIntHashMap<String> map;

    public ManualTagger(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public ManualTagger(InputStream inputStream, boolean internTags) throws IOException {
        Map<String, List<TaggedWord>> mapping = ManualTagger.loadMapping(inputStream, internTags);
        this.map = new TObjectIntHashMap(mapping.size());
        int valueCount = mapping.values().stream().mapToInt(v -> v.size()).sum();
        int firstIndex = 2;
        this.data = new String[valueCount * 2 + firstIndex];
        if (valueCount > 0xFFFFFF) {
            throw new UnsupportedOperationException("Too many values (" + valueCount + "), the storage needs adjusting");
        }
        int index = firstIndex;
        for (Map.Entry<String, List<TaggedWord>> entry : mapping.entrySet()) {
            List<TaggedWord> value = entry.getValue();
            if (value.size() > 255) {
                throw new UnsupportedOperationException("Too many lemmas (" + value.size() + " for " + entry.getKey() + "), the storage needs adjusting");
            }
            this.map.put((Object)entry.getKey(), index / 2 << 8 | value.size());
            for (TaggedWord tw : value) {
                this.data[index++] = tw.getLemma();
                this.data[index++] = tw.getPosTag();
            }
        }
    }

    private static Map<String, List<TaggedWord>> loadMapping(InputStream inputStream, boolean internTags) throws IOException {
        HashMap<String, List<TaggedWord>> map = new HashMap<String, List<TaggedWord>>();
        HashMap interned = new HashMap();
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            int lineCount = 0;
            String separator = DEFAULT_SEPARATOR;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                ++lineCount;
                if (line.startsWith("#separatorRegExp=")) {
                    separator = line.replace("#separatorRegExp=", "");
                }
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                if (line.contains("\u00a0")) {
                    throw new RuntimeException("Non-breaking space found in line #" + lineCount + ": '" + line + "', please remove it");
                }
                String[] parts = (line = StringUtils.substringBefore((String)line, (String)"#").trim()).split(separator);
                if (parts.length != 3) {
                    throw new IOException("Unknown line format in line " + lineCount + " when loading manual tagger dictionary, expected three tab-separated fields: '" + line + "'");
                }
                String lemma = parts[1];
                String form = parts[0];
                if (lemma.equals(form)) {
                    lemma = form;
                }
                lemma = (String)interned.computeIfAbsent(lemma, Function.identity());
                String tag = parts[2].trim();
                String internedTag = internTags ? tag.intern() : (String)interned.computeIfAbsent(tag, Function.identity());
                map.computeIfAbsent(form, __ -> new ArrayList()).add(new TaggedWord(lemma, internedTag));
            }
        }
        return map;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        int value = this.map.get((Object)word);
        if (value == 0) {
            return Collections.emptyList();
        }
        int offset = (value >>> 8) * 2;
        int length = value & 0xFF;
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>(length);
        for (int i = 0; i < length; ++i) {
            result.add(new TaggedWord(this.data[offset + i * 2], this.data[offset + i * 2 + 1]));
        }
        return result;
    }
}

