/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.SolidRanges;
import org.bridj.StructCustomizer;
import org.bridj.StructFieldDescription;
import org.bridj.StructObject;
import org.bridj.StructUtils;
import org.bridj.ann.Virtual;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructDescription {
    protected volatile StructFieldDescription[] fields;
    protected long structSize = -1L;
    protected long structAlignment = -1L;
    protected final Class<?> structClass;
    protected final Type structType;
    protected boolean hasFieldFields;
    StructCustomizer customizer;
    private List<StructFieldDescription> aggregatedFields;
    SolidRanges solidRanges;

    public void prependBytes(long bytes) {
        this.build();
        for (StructFieldDescription field : this.fields) {
            field.offset(bytes);
        }
        this.structSize += bytes;
    }

    public void appendBytes(long bytes) {
        this.build();
        this.structSize += bytes;
    }

    public void setFieldOffset(String fieldName, long fieldOffset, boolean propagateChanges) {
        this.build();
        long propagatedOffsetDelta = 0L;
        long originalOffset = 0L;
        for (StructFieldDescription field : this.fields) {
            if (!field.name.equals(fieldName)) continue;
            originalOffset = field.byteOffset;
            propagatedOffsetDelta = fieldOffset - field.byteOffset;
            field.offset(propagatedOffsetDelta);
            if (propagateChanges) continue;
            long minSize = fieldOffset + field.byteLength;
            this.structSize = this.structSize < minSize ? minSize : this.structSize;
            return;
        }
        this.structSize += propagatedOffsetDelta;
        for (StructFieldDescription field : this.fields) {
            if (field.name.equals(fieldName) || field.byteOffset <= originalOffset) continue;
            field.offset(propagatedOffsetDelta);
        }
    }

    public StructDescription(Class<?> structClass, Type structType, StructCustomizer customizer) {
        this.structClass = structClass;
        this.structType = structType;
        this.customizer = customizer;
        if (Utils.containsTypeVariables(structType)) {
            throw new RuntimeException("Type " + structType + " contains unresolved type variables!");
        }
    }

    boolean isVirtual() {
        for (Method m : this.structClass.getMethods()) {
            if (m.getAnnotation(Virtual.class) == null) continue;
            return true;
        }
        return false;
    }

    public Class<?> getStructClass() {
        return this.structClass;
    }

    public Type getStructType() {
        return this.structType;
    }

    public String toString() {
        return "StructDescription(" + Utils.toString(this.structType) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() {
        if (this.fields == null) {
            StructDescription structDescription = this;
            synchronized (structDescription) {
                if (this.fields == null) {
                    StructUtils.computeStructLayout(this, this.customizer);
                    this.customizer.afterBuild(this);
                    if (BridJ.debug) {
                        BridJ.info(this.describe());
                    }
                }
            }
        }
    }

    public final long getStructSize() {
        this.build();
        return this.structSize;
    }

    public final long getStructAlignment() {
        this.build();
        return this.structAlignment;
    }

    public void setAggregatedFields(List<StructFieldDescription> aggregatedFields) {
        this.aggregatedFields = aggregatedFields;
    }

    public List<StructFieldDescription> getAggregatedFields() {
        this.build();
        return this.aggregatedFields;
    }

    public SolidRanges getSolidRanges() {
        this.build();
        return this.solidRanges;
    }

    public final String describe(StructObject struct) {
        return StructUtils.describe(struct, this.structType, this.fields);
    }

    public final String describe() {
        StringBuilder b = new StringBuilder();
        b.append("// ");
        b.append("size = ").append(this.structSize).append(", ");
        b.append("alignment = ").append(this.structAlignment);
        b.append("\nstruct ");
        b.append(StructUtils.describe(this.structType)).append(" { ");
        int nFields = this.fields.length;
        for (int iField = 0; iField < nFields; ++iField) {
            StructFieldDescription fd = this.fields[iField];
            b.append("\n\t");
            b.append("@Field(").append(iField).append(") ");
            if (fd.isCLong) {
                b.append("@CLong ");
            } else if (fd.isSizeT) {
                b.append("@Ptr ");
            }
            b.append(StructUtils.describe(fd.valueType)).append(" ").append(fd.name).append("; ");
            b.append("// ");
            b.append("offset = ").append(fd.byteOffset).append(", ");
            b.append("length = ").append(fd.byteLength).append(", ");
            if (fd.bitOffset != 0L) {
                b.append("bitOffset = ").append(fd.bitOffset).append(", ");
            }
            if (fd.bitLength != -1L) {
                b.append("bitLength = ").append(fd.bitLength).append(", ");
            }
            if (fd.arrayLength != 1L) {
                b.append("arrayLength = ").append(fd.arrayLength).append(", ");
            }
            if (fd.alignment == 1L) continue;
            b.append("alignment = ").append(fd.alignment);
        }
        b.append("\n}");
        return b.toString();
    }
}

