/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dialog;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class RelationTree
extends JTree {
    protected void build() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new RelationTreeCellRenderer());
        this.addTreeWillExpandListener(new LazyRelationLoader());
    }

    public RelationTree() {
        this.build();
    }

    public RelationTree(RelationTreeModel model) {
        super(model);
        this.build();
    }

    protected Dialog getParentDialog() {
        Container c;
        for (c = this; c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        return (Dialog)c;
    }

    class LazyRelationLoader
    implements TreeWillExpandListener {
        LazyRelationLoader() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            Relation parent = (Relation)event.getPath().getLastPathComponent();
            if (!parent.isIncomplete() || parent.isNew()) {
                return;
            }
            MainApplication.worker.submit(new RelationLoader(RelationTree.this.getParentDialog(), parent, path));
        }
    }

    class RelationLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Exception lastException;
        private final Relation relation;
        private DataSet ds;
        private final TreePath path;

        RelationLoader(Dialog dialog, Relation relation, TreePath path) {
            super(I18n.tr("Load relation", new Object[0]), new PleaseWaitProgressMonitor(dialog), false);
            this.relation = relation;
            this.path = path;
        }

        @Override
        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.canceled = true;
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                Logging.error(this.lastException);
                return;
            }
            DataSet editData = MainApplication.getLayerManager().getEditDataSet();
            DataSetMerger visitor = new DataSetMerger(editData, this.ds);
            visitor.merge();
            if (!visitor.getConflicts().isEmpty()) {
                editData.getConflicts().add(visitor.getConflicts());
            }
            RelationTreeModel model = (RelationTreeModel)RelationTree.this.getModel();
            SwingUtilities.invokeLater(() -> model.refreshNode(this.path));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                OsmServerObjectReader reader = new OsmServerObjectReader(this.relation.getId(), OsmPrimitiveType.from(this.relation), true);
                this.ds = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }
}

