/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmServerHistoryReader
extends OsmServerReader {
    private final OsmPrimitiveType primitiveType;
    private final long id;

    public OsmServerHistoryReader(OsmPrimitiveType type, long id) {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (id < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected. Got ''{1}''.", "id", id));
        }
        this.primitiveType = type;
        this.id = id;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public HistoryDataSet parseHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("");
        try {
            HistoryDataSet historyDataSet;
            block18: {
                InputStream in;
                block16: {
                    HistoryDataSet historyDataSet2;
                    block17: {
                        String urlStr = this.primitiveType.getAPIName() + '/' + this.id + "/history";
                        progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server for {0}", urlStr));
                        in = this.getInputStream(urlStr, progressMonitor.createSubTaskMonitor(1, true));
                        try {
                            if (in != null) break block16;
                            historyDataSet2 = null;
                            if (in == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (OsmTransferException e) {
                                throw e;
                            }
                            catch (IOException | SAXException e) {
                                if (this.cancel) {
                                    HistoryDataSet historyDataSet3 = null;
                                    return historyDataSet3;
                                }
                                throw new OsmTransferException(e);
                            }
                        }
                        in.close();
                    }
                    return historyDataSet2;
                }
                progressMonitor.indeterminateSubTask(I18n.tr("Downloading history...", new Object[0]));
                OsmHistoryReader reader = new OsmHistoryReader(in);
                historyDataSet = reader.parse(progressMonitor.createSubTaskMonitor(1, true));
                if (in == null) break block18;
                in.close();
            }
            return historyDataSet;
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

