/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.LruCache;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public abstract class TaggingPresetItem {
    private static final Map<String, Set<TaggingPresetType>> TYPE_CACHE = new LruCache<String, Set<TaggingPresetType>>(16);
    protected static BooleanProperty DISPLAY_KEYS_AS_HINT = new BooleanProperty("taggingpreset.display-keys-as-hint", true);

    protected void initAutoCompletionField(AutoCompletingTextField field, String ... key) {
        this.initAutoCompletionField(field, Arrays.asList(key));
    }

    protected void initAutoCompletionField(AutoCompletingTextField field, List<String> keys) {
        DataSet data = OsmDataManager.getInstance().getEditDataSet();
        if (data == null) {
            return;
        }
        AutoCompletionList list = new AutoCompletionList();
        AutoCompletionManager.of(data).populateWithTagValues(list, keys);
        field.setAutoCompletionList(list);
    }

    protected abstract boolean addToPanel(JPanel var1, TaggingPresetItemGuiSupport var2);

    protected abstract void addCommands(List<Tag> var1);

    public Boolean matches(Map<String, String> tags) {
        return null;
    }

    protected static Set<TaggingPresetType> getType(String types) throws SAXException {
        if (types == null || types.isEmpty()) {
            throw new SAXException(I18n.tr("Unknown type: {0}", types));
        }
        if (TYPE_CACHE.containsKey(types)) {
            return TYPE_CACHE.get(types);
        }
        EnumSet<TaggingPresetType> result = EnumSet.noneOf(TaggingPresetType.class);
        for (String type : types.split(",", -1)) {
            try {
                TaggingPresetType presetType = TaggingPresetType.fromString(type);
                if (presetType == null) continue;
                result.add(presetType);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(I18n.tr("Unknown type: {0}", type), e);
            }
        }
        TYPE_CACHE.put(types, result);
        return result;
    }

    protected static String fixPresetString(String s) {
        return s == null ? s : s.replace("'", "''");
    }

    protected static String getLocaleText(String text, String textContext, String defaultText) {
        if (text == null) {
            return defaultText;
        }
        if (textContext != null) {
            return I18n.trc(textContext, TaggingPresetItem.fixPresetString(text));
        }
        return I18n.tr(TaggingPresetItem.fixPresetString(text), new Object[0]);
    }

    protected static Integer parseInteger(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static ImageIcon loadImageIcon(String iconName, File zipIcons, Integer maxSize) {
        Object s = TaggingPresets.ICON_SOURCES.get();
        ImageProvider imgProv = new ImageProvider(iconName).setDirs((Collection<String>)s).setId("presets").setArchive(zipIcons).setOptional(true);
        if (maxSize != null && maxSize > 0) {
            imgProv.setMaxSize(maxSize);
        }
        return imgProv.get();
    }

    public static boolean matches(Iterable<? extends TaggingPresetItem> data, Map<String, String> tags) {
        boolean atLeastOnePositiveMatch = false;
        for (TaggingPresetItem taggingPresetItem : data) {
            Boolean m = taggingPresetItem.matches(tags);
            if (m != null && !m.booleanValue()) {
                return false;
            }
            if (m == null) continue;
            atLeastOnePositiveMatch = true;
        }
        return atLeastOnePositiveMatch;
    }
}

