/*
 * Decompiled with CFR 0.152.
 */
package realmyst;

import realmyst.ObjFile;
import shared.FileUtils;
import shared.IBytestream;
import shared.Ntstring;
import shared.b;
import shared.e;
import shared.m;

public class dirtfile {
    Header header;
    dirttree tree;

    public dirtfile(IBytestream c) {
        this.header = new Header(c);
        this.tree = new dirttree(c.Fork(this.header.dirOffset), this.header.FTOffset, true);
    }

    public void saveAllFiles(String outputdir) {
        for (dirttree child : this.tree.xchildren) {
            this.saveAllFiles(child, outputdir);
        }
    }

    private void saveAllFiles(dirttree node, String outputdir) {
        String filename = outputdir + "/" + node.name.toString();
        if (node.isdir) {
            FileUtils.CreateFolder(filename);
            for (dirttree child : node.xchildren) {
                this.saveAllFiles(child, filename);
            }
        } else {
            FileUtils.WriteFile(filename, node.xfile.rawdata);
        }
    }

    public static class FileStruct {
        int nameOffset;
        int extOffset;
        int fileLength;
        int offset;
        int isEmpty;
        static int sum = 0;
        static int all = 0;
        static int diff = 0;
        static int test = 0;
        static int type1 = 0;
        static int type2 = 0;

        public FileStruct(IBytestream c) {
            this.nameOffset = c.readInt();
            this.extOffset = c.readInt();
            this.fileLength = c.readInt();
            this.offset = c.readInt();
            this.isEmpty = c.readInt();
            all += this.fileLength;
            diff += this.fileLength - this.isEmpty;
            test += this.isEmpty == 0 ? this.fileLength : this.isEmpty;
            if (this.isEmpty != 0) {
                boolean dummy = false;
                sum += this.isEmpty;
                ++type2;
            } else {
                ++type1;
            }
            m.msg("type1=" + Integer.toString(type1) + " type2=" + Integer.toString(type2));
        }
    }

    public static class DirectoryTable {
        int nameOffset;
        int numFiles;
        int[] fileOffsets;

        public DirectoryTable(IBytestream c) {
            this.nameOffset = c.readInt();
            this.numFiles = c.readInt();
            this.fileOffsets = c.readInts(this.numFiles);
        }
    }

    public static class Header {
        byte[] header;
        int version;
        int dirOffset;
        int FTOffset;
        int NLOffset;
        int dataOffset;
        int FTOffset2;

        public Header(IBytestream c) {
            this.header = c.readBytes(4);
            e.ensure(b.isEqual(this.header, new byte[]{68, 105, 114, 116}));
            this.version = c.readInt();
            e.ensure(this.version == 65536);
            this.dirOffset = c.readInt();
            this.FTOffset = c.readInt();
            this.NLOffset = c.readInt();
            this.dataOffset = c.readInt();
            this.FTOffset2 = c.readInt();
            e.ensure(this.FTOffset2 == this.FTOffset);
        }
    }

    public static class dirttree {
        Ntstring name;
        ObjFile xfile;
        DirectoryTable xdirtable;
        FileStruct xfilestruct;
        boolean isdir;
        dirttree[] xchildren;

        public dirttree(IBytestream c, int FTOffset, boolean isdirectory) {
            this.isdir = isdirectory;
            if (this.isdir) {
                this.xdirtable = new DirectoryTable(c);
                this.name = new Ntstring(c.Fork(this.xdirtable.nameOffset));
                int childcount = this.xdirtable.numFiles;
                this.xchildren = new dirttree[childcount];
                for (int i = 0; i < childcount; ++i) {
                    int childoffset = this.xdirtable.fileOffsets[i];
                    boolean isChildDir = childoffset < FTOffset;
                    this.xchildren[i] = new dirttree(c.Fork(childoffset), FTOffset, isChildDir);
                }
            } else {
                this.xfilestruct = new FileStruct(c);
                this.name = new Ntstring(c.Fork(this.xfilestruct.nameOffset));
                this.xfile = new ObjFile(c.Fork(this.xfilestruct.offset), this.xfilestruct.fileLength, this.xfilestruct.isEmpty);
            }
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

