/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph;

import org.gradle.internal.logging.text.StyledTextOutput;

public class LegendRenderer {
    private final StyledTextOutput output;
    private boolean hasCyclicDependencies;
    private boolean hasUnresolvableConfigurations;
    private boolean hasConstraints;

    public LegendRenderer(StyledTextOutput output) {
        this.output = output;
    }

    public void printLegend() {
        if (this.hasConstraints) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).text((Object)"(c) - dependency constraint");
        }
        if (this.hasCyclicDependencies) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).println((Object)"(*) - dependencies omitted (listed previously)");
        }
        if (this.hasUnresolvableConfigurations) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).println((Object)"(n) - Not resolved (configuration is not meant to be resolved)");
        }
    }

    public void setHasUnresolvableConfigurations(boolean hasUnresolvableConfigurations) {
        this.hasUnresolvableConfigurations = hasUnresolvableConfigurations;
    }

    public void setHasCyclicDependencies(boolean hasCyclicDependencies) {
        this.hasCyclicDependencies = hasCyclicDependencies;
    }

    public void setHasConstraints(boolean hasConstraints) {
        this.hasConstraints = hasConstraints;
    }
}

