/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;

public class DefaultImmutableModuleIdentifierFactory
implements ImmutableModuleIdentifierFactory {
    private final Map<String, Map<String, ModuleIdentifier>> groupIdToModules = Maps.newConcurrentMap();
    private final Map<ModuleIdentifier, Map<String, ModuleVersionIdentifier>> idToVersions = Maps.newConcurrentMap();

    @Override
    public ModuleIdentifier module(String group, String name) {
        ModuleIdentifier moduleIdentifier;
        Map byName = this.groupIdToModules.get(group);
        if (byName == null) {
            byName = this.groupIdToModules.computeIfAbsent(group, k -> Maps.newConcurrentMap());
        }
        if ((moduleIdentifier = byName.get(name)) == null) {
            moduleIdentifier = DefaultModuleIdentifier.newId(group, name);
            byName.put(name, moduleIdentifier);
        }
        return moduleIdentifier;
    }

    @Override
    public ModuleVersionIdentifier moduleWithVersion(String group, String name, String version) {
        ModuleIdentifier mi = this.module(group, name);
        return this.moduleWithVersion(mi, version);
    }

    @Override
    public ModuleVersionIdentifier moduleWithVersion(ModuleIdentifier mi, String version) {
        ModuleVersionIdentifier identifier;
        Map byVersion = this.idToVersions.get(mi);
        if (byVersion == null) {
            byVersion = this.idToVersions.computeIfAbsent(mi, k -> Maps.newConcurrentMap());
        }
        if ((identifier = byVersion.get(version)) == null) {
            identifier = DefaultModuleVersionIdentifier.newId(mi, version);
            byVersion.put(version, identifier);
        }
        return identifier;
    }
}

