/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantArtifactSelectionMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ComponentResolveMetadata>
extends AbstractComponentGraphResolveState<T, S> {
    private final ConcurrentMap<ConfigurationMetadata, DefaultVariantArtifactResolveState> variants = new ConcurrentHashMap<ConfigurationMetadata, DefaultVariantArtifactResolveState>();
    private final Optional<Set<? extends VariantResolveMetadata>> allVariantsForArtifactSelection;
    private final List<ResolvedVariantResult> selectableVariantResults;

    public DefaultComponentGraphResolveState(T graphMetadata, S artifactMetadata, AttributeDesugaring attributeDesugaring) {
        super(graphMetadata, artifactMetadata, attributeDesugaring);
        this.allVariantsForArtifactSelection = graphMetadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(ModuleConfigurationMetadata.class::cast).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet()));
        this.selectableVariantResults = graphMetadata.getVariantsForGraphTraversal().orElse(Collections.emptyList()).stream().flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new ExternalArtifactResolveMetadata((ComponentResolveMetadata)this.getArtifactMetadata());
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return this.selectableVariantResults;
    }

    @Override
    public VariantArtifactGraphResolveMetadata resolveArtifactsFor(VariantGraphResolveMetadata variant) {
        return (VariantArtifactGraphResolveMetadata)((Object)variant);
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution(VariantGraphResolveMetadata variant) {
        ConfigurationMetadata configurationMetadata = (ConfigurationMetadata)((Object)variant);
        return this.variants.computeIfAbsent(configurationMetadata, c -> new DefaultVariantArtifactResolveState((ComponentResolveMetadata)this.getArtifactMetadata(), configurationMetadata, this.allVariantsForArtifactSelection));
    }

    private static class ExternalArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentResolveMetadata metadata;

        public ExternalArtifactResolveMetadata(ComponentResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class ExternalVariantArtifactSelectionMetadata
    implements VariantArtifactSelectionMetadata {
        private final Set<? extends VariantResolveMetadata> allVariants;
        private final Set<? extends VariantResolveMetadata> legacyVariants;

        public ExternalVariantArtifactSelectionMetadata(Set<? extends VariantResolveMetadata> allVariants, Set<? extends VariantResolveMetadata> legacyVariants) {
            this.allVariants = allVariants;
            this.legacyVariants = legacyVariants;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getAllVariants() {
            return this.allVariants;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getLegacyVariants() {
            return this.legacyVariants;
        }
    }

    private static class DefaultVariantArtifactResolveState
    implements VariantArtifactResolveState {
        private final ComponentResolveMetadata artifactMetadata;
        private final ConfigurationMetadata graphSelectedVariant;
        private final Set<? extends VariantResolveMetadata> legacyVariants;
        private final Set<? extends VariantResolveMetadata> allVariants;

        public DefaultVariantArtifactResolveState(ComponentResolveMetadata artifactMetadata, ConfigurationMetadata graphSelectedVariant, Optional<Set<? extends VariantResolveMetadata>> allVariantsForArtifactSelection) {
            this.artifactMetadata = artifactMetadata;
            this.graphSelectedVariant = graphSelectedVariant;
            this.legacyVariants = graphSelectedVariant.getVariants();
            this.allVariants = allVariantsForArtifactSelection.orElse(this.legacyVariants);
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            return this.graphSelectedVariant.artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            return artifactSelector.resolveArtifacts(new ExternalArtifactResolveMetadata(this.artifactMetadata), new ExternalVariantArtifactSelectionMetadata(this.allVariants, this.legacyVariants), exclusions, overriddenAttributes);
        }
    }
}

