/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ComponentResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final T graphMetadata;
    private final S artifactMetadata;
    private final AttributeDesugaring attributeDesugaring;
    private final ConcurrentMap<VariantGraphResolveMetadata, ResolvedVariantResult> publicViews = new ConcurrentHashMap<VariantGraphResolveMetadata, ResolvedVariantResult>();

    public AbstractComponentGraphResolveState(T graphMetadata, S artifactMetadata, AttributeDesugaring attributeDesugaring) {
        this.graphMetadata = graphMetadata;
        this.artifactMetadata = artifactMetadata;
        this.attributeDesugaring = attributeDesugaring;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    @Override
    public ModuleSources getSources() {
        return this.artifactMetadata.getSources();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    public S getArtifactMetadata() {
        return this.artifactMetadata;
    }

    @Override
    public GraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        final Optional<List<? extends VariantGraphResolveMetadata>> variants = this.graphMetadata.getVariantsForGraphTraversal();
        return new GraphSelectionCandidates(){

            @Override
            public boolean isUseVariants() {
                return variants.isPresent() && !((List)variants.get()).isEmpty();
            }

            @Override
            public List<? extends VariantGraphResolveMetadata> getVariants() {
                return (List)variants.get();
            }

            @Override
            @Nullable
            public ConfigurationGraphResolveMetadata getLegacyConfiguration() {
                return AbstractComponentGraphResolveState.this.graphMetadata.getConfiguration("default");
            }

            @Override
            public List<? extends ConfigurationGraphResolveMetadata> getCandidateConfigurations() {
                Set<String> configurationNames = AbstractComponentGraphResolveState.this.graphMetadata.getConfigurationNames();
                ImmutableList.Builder builder = new ImmutableList.Builder();
                for (String configurationName : configurationNames) {
                    ConfigurationGraphResolveMetadata configuration = AbstractComponentGraphResolveState.this.graphMetadata.getConfiguration(configurationName);
                    if (!configuration.isCanBeConsumed()) continue;
                    builder.add((Object)configuration);
                }
                return builder.build();
            }
        };
    }

    @Override
    public ResolvedVariantResult getVariantResult(VariantGraphResolveMetadata metadata, @Nullable ResolvedVariantResult externalVariant) {
        if (externalVariant != null) {
            return this.createVariantResult(metadata, externalVariant);
        }
        return this.publicViews.computeIfAbsent(metadata, m -> this.createVariantResult(metadata, null));
    }

    private DefaultResolvedVariantResult createVariantResult(VariantGraphResolveMetadata metadata, @Nullable ResolvedVariantResult externalVariant) {
        return new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)metadata.getName()), (AttributeContainer)this.attributeDesugaring.desugar(metadata.getAttributes()), this.capabilitiesFor(metadata.getCapabilities()), externalVariant);
    }

    @Override
    @Nullable
    public ComponentGraphResolveState maybeAsLenientPlatform(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return null;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public void resolveArtifactsWithType(ArtifactResolver artifactResolver, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        artifactResolver.resolveArtifactsWithType(this.getResolveMetadata(), artifactType, result);
    }

    @Override
    public ArtifactSet prepareForArtifactResolution(ArtifactSelector artifactSelector, Collection<? extends ComponentArtifactMetadata> artifacts, ImmutableAttributes overriddenAttributes) {
        return artifactSelector.resolveArtifacts(this.getResolveMetadata(), artifacts, overriddenAttributes);
    }

    protected List<? extends Capability> capabilitiesFor(CapabilitiesMetadata variantCapabilities) {
        List capabilities = variantCapabilities.getCapabilities();
        capabilities = capabilities.isEmpty() ? ImmutableList.of((Object)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId())) : ImmutableList.copyOf((Collection)capabilities);
        return capabilities;
    }
}

