/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantArtifactSelectionMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentMetadata, LocalComponentMetadata>
implements LocalComponentGraphResolveState {
    private final ConcurrentMap<LocalConfigurationGraphResolveMetadata, DefaultLocalVariantArtifactResolveState> variants = new ConcurrentHashMap<LocalConfigurationGraphResolveMetadata, DefaultLocalVariantArtifactResolveState>();
    private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariantsForArtifactSelection = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(LocalConfigurationGraphResolveMetadata.class::cast).map(LocalConfigurationGraphResolveMetadata::prepareToResolveArtifacts).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet())));
    private final Lazy<List<ResolvedVariantResult>> selectableVariantResults = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().orElse(Collections.emptyList()).stream().map(LocalConfigurationGraphResolveMetadata.class::cast).flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList()));

    public DefaultLocalComponentGraphResolveState(LocalComponentMetadata metadata, AttributeDesugaring attributeDesugaring) {
        super(metadata, metadata, attributeDesugaring);
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public LocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        return ((LocalComponentMetadata)this.getMetadata()).copy(componentIdentifier, artifacts);
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new LocalComponentArtifactResolveMetadata((LocalComponentMetadata)this.getMetadata());
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return (List)this.selectableVariantResults.get();
    }

    @Override
    public VariantArtifactGraphResolveMetadata resolveArtifactsFor(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationGraphResolveMetadata)variant);
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationGraphResolveMetadata)variant);
    }

    private DefaultLocalVariantArtifactResolveState stateFor(LocalConfigurationGraphResolveMetadata variant) {
        return this.variants.computeIfAbsent(variant, c -> new DefaultLocalVariantArtifactResolveState((LocalComponentMetadata)this.getMetadata(), variant, this.allVariantsForArtifactSelection));
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final LocalComponentMetadata metadata;

        public LocalComponentArtifactResolveMetadata(LocalComponentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class LocalVariantArtifactSelectionMetadata
    implements VariantArtifactSelectionMetadata {
        private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants;
        private final Set<? extends VariantResolveMetadata> legacyVariants;

        public LocalVariantArtifactSelectionMetadata(Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants, Set<? extends VariantResolveMetadata> legacyVariants) {
            this.allVariants = allVariants;
            this.legacyVariants = legacyVariants;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getAllVariants() {
            return ((Optional)this.allVariants.get()).orElse(this.legacyVariants);
        }

        @Override
        public Set<? extends VariantResolveMetadata> getLegacyVariants() {
            return this.legacyVariants;
        }
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final LocalComponentMetadata component;
        private final LocalConfigurationGraphResolveMetadata graphSelectedVariant;
        private final Set<? extends VariantResolveMetadata> legacyVariants;
        private final Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariants;

        public DefaultLocalVariantArtifactResolveState(LocalComponentMetadata component, LocalConfigurationGraphResolveMetadata graphSelectedVariant, Lazy<Optional<Set<? extends VariantResolveMetadata>>> allVariantsForArtifactSelection) {
            this.component = component;
            this.graphSelectedVariant = graphSelectedVariant;
            this.legacyVariants = graphSelectedVariant.prepareToResolveArtifacts().getVariants();
            this.allVariants = allVariantsForArtifactSelection;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedVariant.prepareToResolveArtifacts().getArtifacts();
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            return this.graphSelectedVariant.prepareToResolveArtifacts().artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            return artifactSelector.resolveArtifacts(new LocalComponentArtifactResolveMetadata(this.component), new LocalVariantArtifactSelectionMetadata(this.allVariants, this.legacyVariants), exclusions, overriddenAttributes);
        }
    }
}

