/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentResultSerializer
implements Serializer<ResolvedGraphComponent> {
    private final ModuleVersionIdentifierSerializer idSerializer;
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentIdentifierSerializer componentIdSerializer;
    private final ResolvedVariantResultSerializer resolvedVariantResultSerializer;
    private final boolean returnAllVariants;

    public ComponentResultSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedVariantResultSerializer resolvedVariantResultSerializer, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ComponentIdentifierSerializer componentIdentifierSerializer, boolean returnAllVariants) {
        this.idSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.componentIdSerializer = componentIdentifierSerializer;
        this.returnAllVariants = returnAllVariants;
    }

    void reset() {
        this.resolvedVariantResultSerializer.reset();
    }

    public ResolvedGraphComponent read(Decoder decoder) throws IOException {
        List<ResolvedVariantResult> availableVariants;
        List<ResolvedVariantResult> resolvedVariants;
        long resultId = decoder.readSmallLong();
        ModuleVersionIdentifier id = this.idSerializer.read(decoder);
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        ComponentIdentifier componentId = this.componentIdSerializer.read(decoder);
        if (decoder.readBoolean()) {
            resolvedVariants = this.readVariantList(decoder);
            availableVariants = this.readAvailableVariants(decoder, resolvedVariants);
        } else {
            availableVariants = resolvedVariants = this.readVariantList(decoder);
        }
        String repositoryName = decoder.readNullableString();
        return new DetachedComponentResult(resultId, id, reason, componentId, resolvedVariants, availableVariants, repositoryName);
    }

    private List<ResolvedVariantResult> readAvailableVariants(Decoder decoder, List<ResolvedVariantResult> selectedVariants) throws IOException {
        int availableVariantsSize = decoder.readSmallInt();
        ImmutableList.Builder availableVariantsBuilder = ImmutableList.builderWithExpectedSize((int)availableVariantsSize);
        for (int i = 0; i < availableVariantsSize; ++i) {
            int index = decoder.readInt();
            if (index >= 0) {
                availableVariantsBuilder.add((Object)selectedVariants.get(index));
                continue;
            }
            availableVariantsBuilder.add((Object)this.resolvedVariantResultSerializer.read(decoder));
        }
        ImmutableList availableVariants = availableVariantsBuilder.build();
        return availableVariants;
    }

    private List<ResolvedVariantResult> readVariantList(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            ResolvedVariantResult variant = this.resolvedVariantResultSerializer.read(decoder);
            builder.add((Object)variant);
        }
        return builder.build();
    }

    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        encoder.writeSmallLong(value.getResultId().longValue());
        this.idSerializer.write(encoder, value.getModuleVersion());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        this.componentIdSerializer.write(encoder, value.getComponentId());
        if (this.returnAllVariants) {
            encoder.writeBoolean(true);
            List<ResolvedVariantResult> selectedVariants = value.getSelectedVariants();
            this.writeVariantList(encoder, selectedVariants);
            this.writeSelectedAndAvailableVariants(encoder, selectedVariants, value.getAvailableVariants());
        } else {
            encoder.writeBoolean(false);
            this.writeVariantList(encoder, value.getSelectedVariants());
        }
        encoder.writeNullableString((CharSequence)value.getRepositoryName());
    }

    private void writeSelectedAndAvailableVariants(Encoder encoder, List<ResolvedVariantResult> selectedVariants, List<ResolvedVariantResult> variants) throws IOException {
        encoder.writeSmallInt(variants.size());
        for (ResolvedVariantResult variant : variants) {
            int index = selectedVariants.indexOf(variant);
            encoder.writeInt(index);
            if (index >= 0) continue;
            this.resolvedVariantResultSerializer.write(encoder, variant);
        }
    }

    private void writeVariantList(Encoder encoder, List<ResolvedVariantResult> variants) throws IOException {
        encoder.writeSmallInt(variants.size());
        for (ResolvedVariantResult variant : variants) {
            this.resolvedVariantResultSerializer.write(encoder, variant);
        }
    }
}

