/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class SimpleGlobalFilesBuildSettingsDescriptor
implements BuildContentGenerator {
    static final String PLUGINS_BUILD_LOCATION = "build-logic";
    private final DocumentationRegistry documentationRegistry;
    private final BuildScriptBuilderFactory scriptBuilderFactory;

    public SimpleGlobalFilesBuildSettingsDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, DocumentationRegistry documentationRegistry) {
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.documentationRegistry = documentationRegistry;
    }

    public void generateWithoutComments(InitSettings settings) {
        this.builder(settings).withExternalComments().create(settings.getTarget()).generate();
    }

    @Override
    public void generate(InitSettings settings) {
        this.builder(settings).create(settings.getTarget()).generate();
    }

    private BuildScriptBuilder builder(InitSettings settings) {
        BuildScriptBuilder builder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), "settings", settings.isUseIncubatingAPIs());
        builder.fileComment("The settings file is used to specify which projects to include in your build.\n\n").fileComment(this.documentationRegistry.getDocumentationRecommendationFor("detailed information on multi-project builds", "building_swift_projects"));
        if (settings.getModularizationOption() == ModularizationOption.WITH_LIBRARY_PROJECTS && settings.isUseIncubatingAPIs()) {
            builder.includePluginsBuild();
        }
        if (settings.getJavaLanguageVersion().isPresent()) {
            builder.plugin("Apply the foojay-resolver plugin to allow automatic download of JDKs", "org.gradle.toolchains.foojay-resolver-convention", "0.4.0");
        }
        builder.propertyAssignment(null, "rootProject.name", settings.getProjectName());
        if (!settings.getSubprojects().isEmpty()) {
            builder.methodInvocation(null, "include", settings.getSubprojects().toArray());
        }
        return builder;
    }
}

