/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;

public abstract class JavaLibraryPlugin
implements Plugin<Project> {
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    @Inject
    public JavaLibraryPlugin(JvmEcosystemUtilities jvmEcosystemUtilities) {
        this.jvmEcosystemUtilities = jvmEcosystemUtilities;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        JvmSoftwareComponentInternal component = JavaPluginHelper.getJavaComponent(project);
        SourceSet sourceSet = component.getSourceSet();
        this.jvmEcosystemUtilities.configureClassesDirectoryVariant(component.getApiElementsConfiguration(), sourceSet);
        RoleBasedConfigurationContainerInternal configurations = (RoleBasedConfigurationContainerInternal)project.getConfigurations();
        Configuration api = configurations.maybeCreateWithRole(sourceSet.getApiConfigurationName(), (ConfigurationRole)ConfigurationRoles.INTENDED_BUCKET, false, false);
        api.setDescription("API dependencies for " + sourceSet + ".");
        api.setVisible(false);
        Configuration compileOnlyApi = configurations.maybeCreateWithRole(sourceSet.getCompileOnlyApiConfigurationName(), (ConfigurationRole)ConfigurationRoles.INTENDED_BUCKET, false, false);
        compileOnlyApi.setDescription("Compile only API dependencies for " + sourceSet + ".");
        compileOnlyApi.setVisible(false);
        component.getApiElementsConfiguration().extendsFrom(new Configuration[]{api, compileOnlyApi});
        component.getImplementationConfiguration().extendsFrom(new Configuration[]{api});
        component.getCompileOnlyConfiguration().extendsFrom(new Configuration[]{compileOnlyApi});
        JvmTestSuite defaultTestSuite = JavaPluginHelper.getDefaultTestSuite(project);
        configurations.getByName(defaultTestSuite.getSources().getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{compileOnlyApi});
    }
}

