/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTransformationNodeFactory
implements TransformationNodeFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public DefaultTransformationNodeFactory(BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public Collection<TransformationNode> create(ResolvedArtifactSet artifactSet, final ComponentVariantIdentifier targetComponentVariant, final TransformationStep transformationStep, final AttributeContainer sourceAttributes, final TransformUpstreamDependenciesResolver dependenciesResolver) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        artifactSet.visitTransformSources(new ResolvedArtifactSet.TransformSourceVisitor(){

            @Override
            public void visitArtifact(ResolvableArtifact artifact) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformationStep);
                TransformationNode.InitialTransformationNode transformationNode = TransformationNode.initial(targetComponentVariant, sourceAttributes, transformationStep, artifact, upstreamDependencies, DefaultTransformationNodeFactory.this.buildOperationExecutor, DefaultTransformationNodeFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformationNode);
            }

            @Override
            public void visitTransform(TransformationNode source) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformationStep);
                TransformationNode.ChainedTransformationNode transformationNode = TransformationNode.chained(targetComponentVariant, sourceAttributes, transformationStep, source, upstreamDependencies, DefaultTransformationNodeFactory.this.buildOperationExecutor, DefaultTransformationNodeFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformationNode);
            }
        });
        return builder.build();
    }
}

