/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultNativeBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.internal.modulemap.ModuleMap;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultSwiftBinary
extends DefaultNativeBinary
implements SwiftBinary {
    private final NativeVariantIdentity identity;
    private final Provider<String> module;
    private final boolean testable;
    private final FileCollection source;
    private final FileCollection compileModules;
    private final Configuration linkLibs;
    private final Configuration runtimeLibs;
    private final RegularFileProperty moduleFile;
    private final Property<SwiftCompile> compileTaskProperty;
    private final SwiftPlatform targetPlatform;
    private final NativeToolChainInternal toolChain;
    private final PlatformToolProvider platformToolProvider;
    private final Configuration importPathConfiguration;

    public DefaultSwiftBinary(Names names, ObjectFactory objectFactory, TaskDependencyFactory taskDependencyFactory, Provider<String> module, boolean testable, FileCollection source, ConfigurationContainer configurations, Configuration componentImplementation, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, objectFactory, componentImplementation);
        this.module = module;
        this.testable = testable;
        this.source = source;
        this.moduleFile = objectFactory.fileProperty();
        this.compileTaskProperty = objectFactory.property(SwiftCompile.class);
        this.targetPlatform = targetPlatform;
        this.toolChain = toolChain;
        this.platformToolProvider = platformToolProvider;
        RoleBasedConfigurationContainerInternal rbConfigurations = (RoleBasedConfigurationContainerInternal)configurations;
        this.importPathConfiguration = rbConfigurations.resolvableBucket(names.withPrefix("swiftCompile"));
        this.importPathConfiguration.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        this.importPathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "swift-api")));
        this.importPathConfiguration.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        this.importPathConfiguration.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        this.importPathConfiguration.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        this.importPathConfiguration.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        Configuration nativeLink = rbConfigurations.resolvableBucket(names.withPrefix("nativeLink"));
        nativeLink.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "native-link")));
        nativeLink.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeLink.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeLink.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeLink.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        Configuration nativeRuntime = rbConfigurations.createWithRole(names.withPrefix("nativeRuntime"), (ConfigurationRole)ConfigurationRolesForMigration.INTENDED_RESOLVABLE_BUCKET_TO_INTENDED_RESOLVABLE);
        nativeRuntime.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "native-runtime")));
        nativeRuntime.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeRuntime.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeRuntime.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeRuntime.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        this.compileModules = new FileCollectionAdapter((MinimalFileSet)new ModulePath(this.importPathConfiguration), taskDependencyFactory);
        this.linkLibs = nativeLink;
        this.runtimeLibs = nativeRuntime;
        this.identity = identity;
    }

    @Override
    public Provider<String> getModule() {
        return this.module;
    }

    @Override
    public Provider<String> getBaseName() {
        return this.module;
    }

    @Override
    public boolean isDebuggable() {
        return this.identity.isDebuggable();
    }

    @Override
    public boolean isOptimized() {
        return this.identity.isOptimized();
    }

    @Override
    public boolean isTestable() {
        return this.testable;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.source;
    }

    @Override
    public FileCollection getCompileModules() {
        return this.compileModules;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibs;
    }

    public Configuration getLinkConfiguration() {
        return this.linkLibs;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibs;
    }

    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    public Configuration getImportPathConfiguration() {
        return this.importPathConfiguration;
    }

    public Property<SwiftCompile> getCompileTask() {
        return this.compileTaskProperty;
    }

    @Override
    public TargetMachine getTargetMachine() {
        return this.targetPlatform.getTargetMachine();
    }

    @Override
    public SwiftPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public NativePlatform getNativePlatform() {
        return ((DefaultSwiftPlatform)this.targetPlatform).getNativePlatform();
    }

    public NativeToolChainInternal getToolChain() {
        return this.toolChain;
    }

    public PlatformToolProvider getPlatformToolProvider() {
        return this.platformToolProvider;
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    public NativeVariantIdentity getIdentity() {
        return this.identity;
    }

    private class ModulePath
    implements MinimalFileSet,
    Buildable {
        private final Configuration importPathConfig;
        private Set<File> result;

        ModulePath(Configuration importPathConfig) {
            this.importPathConfig = importPathConfig;
        }

        public String getDisplayName() {
            return "Module include path for " + DefaultSwiftBinary.this.toString();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                this.result = Sets.newLinkedHashSet();
                LinkedHashMap moduleMaps = Maps.newLinkedHashMap();
                for (ResolvedArtifactResult artifact : this.importPathConfig.getIncoming().getArtifacts()) {
                    Usage usage = (Usage)artifact.getVariant().getAttributes().getAttribute(Usage.USAGE_ATTRIBUTE);
                    if (usage != null && "cplusplus-api".equals(usage.getName())) {
                        ModuleMap moduleMap;
                        String moduleName;
                        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
                        if (ModuleComponentIdentifier.class.isAssignableFrom(id.getClass())) {
                            moduleName = ((ModuleComponentIdentifier)id).getModule();
                        } else if (ProjectComponentIdentifier.class.isAssignableFrom(id.getClass())) {
                            moduleName = ((ProjectComponentIdentifier)id).getProjectName();
                        } else {
                            throw new IllegalArgumentException("Could not determine the name of " + id.getDisplayName() + ": unknown component identifier type: " + id.getClass().getSimpleName());
                        }
                        if (moduleMaps.containsKey(id)) {
                            moduleMap = (ModuleMap)moduleMaps.get(id);
                        } else {
                            moduleMap = new ModuleMap(moduleName, (List)Lists.newArrayList());
                            moduleMaps.put(id, moduleMap);
                        }
                        moduleMap.getPublicHeaderPaths().add(artifact.getFile().getAbsolutePath());
                    }
                    this.result.add(artifact.getFile());
                }
                if (!moduleMaps.isEmpty()) {
                    NativeDependencyCache cache = DefaultSwiftBinary.this.getNativeDependencyCache();
                    for (ModuleMap moduleMap : moduleMaps.values()) {
                        this.result.add(cache.getModuleMapFile(moduleMap));
                    }
                }
            }
            return this.result;
        }

        public TaskDependency getBuildDependencies() {
            return this.importPathConfig.getBuildDependencies();
        }
    }
}

