/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala.internal;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.internal.ScalaRuntimeHelper;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.util.internal.VersionNumber;

public class ScalaCompileOptionsConfigurer {
    private static final int FALLBACK_JVM_TARGET = 8;
    private static final List<String> TARGET_DEFINING_PARAMETERS = Arrays.asList("-target:", "--target:", "-release:", "--release:", "-Xtarget:", "-java-output-version:", "-Xunchecked-java-output-version:");
    private static final VersionNumber PLAIN_TARGET_FORMAT_SINCE_VERSION = VersionNumber.parse((String)"2.13.1");
    private static final VersionNumber RELEASE_REPLACES_TARGET_SINCE_VERSION = VersionNumber.parse((String)"2.13.9");

    public static void configure(ScalaCompileOptions scalaCompileOptions, JavaInstallationMetadata toolchain, Set<File> scalaClasspath) {
        if (toolchain == null) {
            return;
        }
        File scalaJar = ScalaRuntimeHelper.findScalaJar(scalaClasspath, "library_3");
        if (scalaJar == null && (scalaJar = ScalaRuntimeHelper.findScalaJar(scalaClasspath, "library")) == null) {
            return;
        }
        VersionNumber scalaVersion = VersionNumber.parse((String)ScalaRuntimeHelper.getScalaVersion(scalaJar));
        if (VersionNumber.UNKNOWN.equals((Object)scalaVersion)) {
            return;
        }
        if (ScalaCompileOptionsConfigurer.hasTargetDefiningParameter(scalaCompileOptions.getAdditionalParameters())) {
            return;
        }
        String targetParameter = ScalaCompileOptionsConfigurer.determineTargetParameter(scalaVersion, (JavaToolchain)toolchain);
        scalaCompileOptions.getAdditionalParameters().add(targetParameter);
    }

    private static boolean hasTargetDefiningParameter(List<String> additionalParameters) {
        return additionalParameters.stream().anyMatch(s -> TARGET_DEFINING_PARAMETERS.stream().anyMatch(s::startsWith));
    }

    private static String determineTargetParameter(VersionNumber scalaVersion, JavaToolchain javaToolchain) {
        int effectiveTarget;
        boolean explicitToolchain = !javaToolchain.isFallbackToolchain();
        int n = effectiveTarget = !explicitToolchain ? 8 : javaToolchain.getLanguageVersion().asInt();
        if (scalaVersion.compareTo(VersionNumber.parse((String)"3.0.0")) >= 0) {
            if (explicitToolchain) {
                return String.format("-release:%s", effectiveTarget);
            }
            return String.format("-Xtarget:%s", effectiveTarget);
        }
        if (scalaVersion.compareTo(RELEASE_REPLACES_TARGET_SINCE_VERSION) >= 0) {
            if (explicitToolchain) {
                return String.format("-release:%s", effectiveTarget);
            }
            return String.format("-target:%s", effectiveTarget);
        }
        if (scalaVersion.compareTo(PLAIN_TARGET_FORMAT_SINCE_VERSION) >= 0) {
            return String.format("-target:%s", effectiveTarget);
        }
        return String.format("-target:jvm-1.%s", effectiveTarget);
    }
}

