/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.processors.StandardOutputRedirector;
import org.gradle.api.internal.tasks.testing.processors.TestOutputRedirector;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;

public class CaptureTestOutputTestResultProcessor
implements TestResultProcessor {
    private final TestResultProcessor processor;
    private final TestOutputRedirector outputRedirector;
    private Object rootId;
    private Map<Object, Object> parents = new ConcurrentHashMap<Object, Object>();

    public CaptureTestOutputTestResultProcessor(TestResultProcessor processor, StandardOutputRedirector outputRedirector) {
        this(processor, new TestOutputRedirector(processor, outputRedirector));
    }

    CaptureTestOutputTestResultProcessor(TestResultProcessor processor, TestOutputRedirector outputRedirector) {
        this.processor = processor;
        this.outputRedirector = outputRedirector;
    }

    @Override
    public void started(TestDescriptorInternal test, TestStartEvent event) {
        this.processor.started(test, event);
        this.outputRedirector.setOutputOwner(test.getId());
        if (this.rootId == null) {
            this.outputRedirector.startRedirecting();
            this.rootId = test.getId();
        } else {
            Object parentId = event.getParentId();
            if (parentId == null) {
                parentId = this.rootId;
            }
            this.parents.put(test.getId(), parentId);
        }
    }

    @Override
    public void completed(Object testId, TestCompleteEvent event) {
        if (testId.equals(this.rootId)) {
            try {
                this.outputRedirector.stopRedirecting();
            }
            finally {
                this.rootId = null;
            }
        } else {
            Object newOwner = this.parents.remove(testId);
            this.outputRedirector.setOutputOwner(newOwner);
        }
        this.processor.completed(testId, event);
    }

    @Override
    public void output(Object testId, TestOutputEvent event) {
        this.processor.output(testId, event);
    }

    @Override
    public void failure(Object testId, TestFailure result) {
        this.processor.failure(testId, result);
    }
}

