/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.Iterables;
import java.util.NavigableSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.NodeSets;
import org.gradle.execution.plan.TaskInAnotherBuild;

public abstract class TaskNode
extends Node {
    private final NavigableSet<Node> shouldSuccessors = NodeSets.newSortedNodeSet();
    private final NavigableSet<Node> finalizingSuccessors = NodeSets.newSortedNodeSet();

    @Override
    protected void nodeSpecificHealthDiagnostics(StringBuilder builder) {
        if (!this.finalizingSuccessors.isEmpty()) {
            builder.append(", finalizes=").append(TaskNode.formatNodes(this.finalizingSuccessors));
        }
    }

    public Set<Node> getMustSuccessors() {
        return this.getDependencyNodes().getMustSuccessors();
    }

    public abstract Set<Node> getLifecycleSuccessors();

    public abstract void setLifecycleSuccessors(Set<Node> var1);

    @Override
    public Set<Node> getFinalizingSuccessors() {
        return this.finalizingSuccessors;
    }

    public Set<Node> getShouldSuccessors() {
        return this.shouldSuccessors;
    }

    public void addMustSuccessor(Node toNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("mustRunAfter", toNode);
        this.updateDependencyNodes(this.getDependencyNodes().addMustSuccessor(toNode));
        toNode.addMustPredecessor(this);
    }

    public void addFinalizingSuccessor(Node finalized) {
        this.finalizingSuccessors.add(finalized);
        finalized.addFinalizer(this);
    }

    public void addShouldSuccessor(Node toNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("shouldRunAfter", toNode);
        this.shouldSuccessors.add(toNode);
    }

    public void removeShouldSuccessor(TaskNode toNode) {
        this.shouldSuccessors.remove(toNode);
    }

    @Override
    public Iterable<Node> getAllSuccessors() {
        return Iterables.concat(this.shouldSuccessors, this.finalizingSuccessors, this.getMustSuccessors(), super.getAllSuccessors());
    }

    @Override
    public Iterable<Node> getHardSuccessors() {
        return Iterables.concat(this.finalizingSuccessors, this.getMustSuccessors(), super.getHardSuccessors());
    }

    public abstract TaskInternal getTask();

    protected void deprecateLifecycleHookReferencingNonLocalTask(String hookName, Node taskNode) {
        if (taskNode instanceof TaskInAnotherBuild) {
            throw new GradleException("Cannot use " + hookName + " to reference tasks from another build");
        }
    }

    @Override
    public void maybeInheritFinalizerGroups() {
        super.maybeInheritFinalizerGroups();
        if (!this.getFinalizingSuccessors().isEmpty()) {
            NodeGroup oldGroup = this.getGroup();
            FinalizerGroup finalizerGroup = new FinalizerGroup(this, oldGroup);
            this.setGroup(finalizerGroup);
        }
    }
}

