/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public class ProjectArtifactResolver
implements ArtifactResolver,
HoldsProjectState {
    private final Map<ComponentArtifactIdentifier, ResolvableArtifact> allResolvedArtifacts = Maps.newConcurrentMap();
    private final ProjectStateRegistry projectStateRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public ProjectArtifactResolver(ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.projectStateRegistry = projectStateRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveArtifact(ModuleVersionIdentifier ownerId, ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactResolveResult result) {
        ResolvableArtifact resolvableArtifact = this.allResolvedArtifacts.get(artifact.getId());
        if (resolvableArtifact == null) {
            LocalComponentArtifactMetadata projectArtifact = (LocalComponentArtifactMetadata)artifact;
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)artifact.getComponentId();
            File localArtifactFile = (File)this.projectStateRegistry.stateFor(projectId).fromMutableState(p -> projectArtifact.getFile());
            if (localArtifactFile != null) {
                CalculatedValueContainer artifactSource = this.calculatedValueContainerFactory.create(Describables.of((Object)artifact.getId()), this.resolveArtifactLater(artifact));
                resolvableArtifact = new DefaultResolvableArtifact(ownerId, artifact.getName(), artifact.getId(), context -> context.add((Object)artifact.getBuildDependencies()), (CalculatedValue<File>)artifactSource, this.calculatedValueContainerFactory);
                this.allResolvedArtifacts.put(artifact.getId(), resolvableArtifact);
            }
        }
        if (resolvableArtifact != null) {
            result.resolved(resolvableArtifact);
        } else {
            result.notFound(artifact.getId());
        }
    }

    public ValueCalculator<File> resolveArtifactLater(ComponentArtifactMetadata artifact) {
        LocalComponentArtifactMetadata projectArtifact = (LocalComponentArtifactMetadata)artifact;
        ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)artifact.getComponentId();
        ProjectState projectState = this.projectStateRegistry.stateFor(projectId);
        return new ResolvingCalculator(projectState, projectArtifact);
    }

    public void discardAll() {
        this.allResolvedArtifacts.clear();
    }

    private static class ResolvingCalculator
    implements ValueCalculator<File> {
        private final ProjectState projectState;
        private final LocalComponentArtifactMetadata projectArtifact;

        public ResolvingCalculator(ProjectState projectState, LocalComponentArtifactMetadata projectArtifact) {
            this.projectState = projectState;
            this.projectArtifact = projectArtifact;
        }

        public boolean usesMutableProjectState() {
            return true;
        }

        public ProjectInternal getOwningProject() {
            return this.projectState.getMutableModel();
        }

        public File calculateValue(NodeExecutionContext context) {
            return (File)this.projectState.fromMutableState(p -> this.projectArtifact.getFile());
        }
    }
}

