/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class JavaInstallationRegistry {
    private final BuildOperationExecutor executor;
    private final Installations installations;
    private final Logger logger;
    private final OperatingSystem os;

    @Inject
    public JavaInstallationRegistry(List<InstallationSupplier> suppliers, BuildOperationExecutor executor, OperatingSystem os) {
        this(suppliers, Logging.getLogger(JavaInstallationRegistry.class), executor, os);
    }

    private JavaInstallationRegistry(List<InstallationSupplier> suppliers, Logger logger, BuildOperationExecutor executor, OperatingSystem os) {
        this.logger = logger;
        this.executor = executor;
        this.installations = new Installations((Supplier<Set<InstallationLocation>>)((Supplier)() -> this.collectInBuildOperation(suppliers)));
        this.os = os;
    }

    @VisibleForTesting
    static JavaInstallationRegistry withLogger(List<InstallationSupplier> suppliers, Logger logger, BuildOperationExecutor executor) {
        return new JavaInstallationRegistry(suppliers, logger, executor, OperatingSystem.current());
    }

    private Set<InstallationLocation> collectInBuildOperation(List<InstallationSupplier> suppliers) {
        return (Set)this.executor.call((CallableBuildOperation)new ToolchainDetectionBuildOperation(() -> this.collectInstallations(suppliers)));
    }

    public Set<InstallationLocation> listInstallations() {
        return this.installations.get();
    }

    public void addInstallation(InstallationLocation installation) {
        this.installations.add(installation);
    }

    private Set<InstallationLocation> collectInstallations(List<InstallationSupplier> suppliers) {
        return suppliers.parallelStream().map(java.util.function.Supplier::get).flatMap(Collection::stream).filter(this::installationExists).map(this::canonicalize).filter(JavaInstallationRegistry.distinctByKey(InstallationLocation::getLocation)).collect(Collectors.toSet());
    }

    boolean installationExists(InstallationLocation installationLocation) {
        File file = installationLocation.getLocation();
        if (!file.exists()) {
            this.logger.warn("Directory {} used for java installations does not exist", (Object)installationLocation.getDisplayName());
            return false;
        }
        if (!file.isDirectory()) {
            this.logger.warn("Path for java installation {} points to a file, not a directory", (Object)installationLocation.getDisplayName());
            return false;
        }
        return true;
    }

    private InstallationLocation canonicalize(InstallationLocation location) {
        File file = location.getLocation();
        try {
            File canonicalFile = file.getCanonicalFile();
            File javaHome = this.findJavaHome(canonicalFile);
            return new InstallationLocation(javaHome, location.getSource());
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not canonicalize path to java installation: %s.", file), (Throwable)e);
        }
    }

    private File findJavaHome(File potentialHome) {
        if (this.os.isMacOsX() && new File(potentialHome, "Contents/Home").exists()) {
            return new File(potentialHome, "Contents/Home");
        }
        File standaloneJre = new File(potentialHome, "jre");
        if (!this.hasJavaExecutable(potentialHome) && this.hasJavaExecutable(standaloneJre)) {
            return standaloneJre;
        }
        return potentialHome;
    }

    private boolean hasJavaExecutable(File potentialHome) {
        return new File(potentialHome, this.os.getExecutableName("bin/java")).exists();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static class Installations {
        private final Supplier<Set<InstallationLocation>> initialiser;
        private Set<InstallationLocation> locations = null;

        Installations(Supplier<Set<InstallationLocation>> initialiser) {
            this.initialiser = initialiser;
        }

        synchronized Set<InstallationLocation> get() {
            this.initIfNeeded();
            return this.locations;
        }

        synchronized void add(InstallationLocation location) {
            this.initIfNeeded();
            this.locations.add(location);
        }

        private void initIfNeeded() {
            if (this.locations == null) {
                this.locations = (Set)this.initialiser.get();
            }
        }
    }

    private static class ToolchainDetectionBuildOperation
    implements CallableBuildOperation<Set<InstallationLocation>> {
        private final Callable<Set<InstallationLocation>> detectionStrategy;

        public ToolchainDetectionBuildOperation(Callable<Set<InstallationLocation>> detectionStrategy) {
            this.detectionStrategy = detectionStrategy;
        }

        public Set<InstallationLocation> call(BuildOperationContext context) throws Exception {
            return this.detectionStrategy.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Toolchain detection").progressDisplayName("Detecting local java toolchains");
        }
    }
}

