/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainUsageProgressDetails;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaInstallationRegistry;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainComparator;
import org.gradle.jvm.toolchain.internal.JavaToolchainFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.JavaToolchainInstantiationResult;
import org.gradle.jvm.toolchain.internal.JavaToolchainMatcher;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;

@ServiceScope(value=Scopes.Project.class)
public class JavaToolchainQueryService {
    private static final JavaToolchainSpecInternal.Key FALLBACK_TOOLCHAIN_KEY = new JavaToolchainSpecInternal.Key(){

        public String toString() {
            return "FallbackToolchainSpecKey";
        }
    };
    private final JavaInstallationRegistry registry;
    private final JavaToolchainFactory toolchainFactory;
    private final JavaToolchainProvisioningService installService;
    private final Provider<Boolean> detectEnabled;
    private final Provider<Boolean> downloadEnabled;
    private final ConcurrentMap<JavaToolchainSpecInternal.Key, Object> matchingToolchains;
    private final CurrentJvmToolchainSpec fallbackToolchainSpec;

    @Inject
    public JavaToolchainQueryService(JavaInstallationRegistry registry, JavaToolchainFactory toolchainFactory, JavaToolchainProvisioningService provisioningService, ProviderFactory factory, ObjectFactory objectFactory) {
        this.registry = registry;
        this.toolchainFactory = toolchainFactory;
        this.installService = provisioningService;
        this.detectEnabled = factory.gradleProperty("org.gradle.java.installations.auto-detect").map(Boolean::parseBoolean);
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").map(Boolean::parseBoolean);
        this.matchingToolchains = new ConcurrentHashMap<JavaToolchainSpecInternal.Key, Object>();
        this.fallbackToolchainSpec = (CurrentJvmToolchainSpec)objectFactory.newInstance(CurrentJvmToolchainSpec.class, new Object[0]);
    }

    <T> Provider<T> toolFor(JavaToolchainSpec spec, Transformer<T, JavaToolchain> toolFunction, DefaultJavaToolchainUsageProgressDetails.JavaTool requestedTool) {
        return this.findMatchingToolchain(spec).withSideEffect((ValueSupplier.SideEffect & Serializable)toolchain -> toolchain.emitUsageEvent(requestedTool)).map(toolFunction);
    }

    @VisibleForTesting
    ProviderInternal<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        JavaToolchainSpecInternal filterInternal = (JavaToolchainSpecInternal)Objects.requireNonNull(filter);
        return new DefaultProvider(() -> this.resolveToolchain(filterInternal));
    }

    private JavaToolchain resolveToolchain(JavaToolchainSpecInternal requestedSpec) throws Exception {
        JavaToolchainSpecInternal actualSpec;
        requestedSpec.finalizeProperties();
        if (!requestedSpec.isValid()) {
            throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary("Using toolchain specifications without setting a language version is not supported.").withAdvice("Consider configuring the language version.").withUpgradeGuideSection(7, "invalid_toolchain_specification_deprecation")).build();
        }
        boolean useFallback = !requestedSpec.isConfigured();
        JavaToolchainSpecInternal.Key actualKey = useFallback ? FALLBACK_TOOLCHAIN_KEY : requestedSpec.toKey();
        Object resolutionResult = this.matchingToolchains.computeIfAbsent(actualKey, arg_0 -> this.lambda$resolveToolchain$1(actualSpec = useFallback ? this.fallbackToolchainSpec : requestedSpec, useFallback, arg_0));
        if (resolutionResult instanceof Exception) {
            throw (Exception)resolutionResult;
        }
        return (JavaToolchain)resolutionResult;
    }

    private JavaToolchain query(JavaToolchainSpec spec, boolean isFallback) {
        if (spec instanceof CurrentJvmToolchainSpec) {
            return this.asToolchain(new InstallationLocation(Jvm.current().getJavaHome(), "current JVM"), spec, isFallback).toolchain().get();
        }
        if (spec instanceof SpecificInstallationToolchainSpec) {
            InstallationLocation installation = new InstallationLocation(((SpecificInstallationToolchainSpec)spec).getJavaHome(), "specific installation");
            return this.asToolchainOrThrow(installation, spec);
        }
        Optional<JavaToolchain> detectedToolchain = this.registry.listInstallations().stream().map(javaHome -> this.asToolchain((InstallationLocation)javaHome, spec)).filter(Optional::isPresent).map(Optional::get).filter(new JavaToolchainMatcher(spec)).min(new JavaToolchainComparator());
        if (detectedToolchain.isPresent()) {
            return detectedToolchain.get();
        }
        InstallationLocation downloadedInstallation = this.downloadToolchain(spec);
        JavaToolchain downloadedToolchain = this.asToolchainOrThrow(downloadedInstallation, spec);
        this.registry.addInstallation(downloadedInstallation);
        return downloadedToolchain;
    }

    private InstallationLocation downloadToolchain(JavaToolchainSpec spec) {
        Optional<File> installation = this.installService.tryInstall(spec);
        if (!installation.isPresent()) {
            throw new NoToolchainAvailableException(spec, (Boolean)this.detectEnabled.getOrElse((Object)true), (Boolean)this.downloadEnabled.getOrElse((Object)true));
        }
        return new InstallationLocation(installation.get(), "provisioned toolchain");
    }

    private Optional<JavaToolchain> asToolchain(InstallationLocation javaHome, JavaToolchainSpec spec) {
        return this.asToolchain(javaHome, spec, false).toolchain();
    }

    private JavaToolchain asToolchainOrThrow(InstallationLocation javaHome, JavaToolchainSpec spec) {
        JavaToolchainInstantiationResult result = this.asToolchain(javaHome, spec, false);
        Optional<JavaToolchain> toolchain = result.toolchain();
        if (!toolchain.isPresent()) {
            JvmInstallationMetadata metadata = result.metadata();
            throw new GradleException("Toolchain installation '" + javaHome.getLocation() + "' could not be probed: " + metadata.getErrorMessage(), metadata.getErrorCause());
        }
        return toolchain.get();
    }

    private JavaToolchainInstantiationResult asToolchain(InstallationLocation javaHome, JavaToolchainSpec spec, boolean isFallback) {
        return this.toolchainFactory.newInstance(javaHome, new JavaToolchainInput(spec), isFallback);
    }

    private /* synthetic */ Object lambda$resolveToolchain$1(JavaToolchainSpecInternal actualSpec, boolean useFallback, JavaToolchainSpecInternal.Key key) {
        try {
            return this.query(actualSpec, useFallback);
        }
        catch (Exception e) {
            return e;
        }
    }
}

