/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.File;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.DependenciesAccessors;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.internal.buildtree.BuildInclusionCoordinator;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.service.ServiceRegistry;

public class BuildTreePreparingProjectsPreparer
implements ProjectsPreparer {
    private final ProjectsPreparer delegate;
    private final BuildInclusionCoordinator coordinator;
    private final BuildSourceBuilder buildSourceBuilder;
    private final BuildLoader buildLoader;

    public BuildTreePreparingProjectsPreparer(ProjectsPreparer delegate, BuildLoader buildLoader, BuildInclusionCoordinator coordinator, BuildSourceBuilder buildSourceBuilder) {
        this.delegate = delegate;
        this.buildLoader = buildLoader;
        this.coordinator = coordinator;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        SettingsInternal settings = gradle.getSettings();
        ClassLoaderScope settingsClassLoaderScope = settings.getClassLoaderScope();
        ClassLoaderScope buildSrcClassLoaderScope = settingsClassLoaderScope.createChild("buildSrc[" + gradle.getIdentityPath() + "]", null);
        gradle.setBaseProjectClassLoaderScope(buildSrcClassLoaderScope);
        this.generateDependenciesAccessorsAndAssignPluginVersions(gradle.getServices(), settings, buildSrcClassLoaderScope);
        this.buildLoader.load(gradle.getSettings(), gradle);
        if (gradle.isRootBuild()) {
            this.coordinator.registerGlobalLibrarySubstitutions();
        }
        this.buildBuildSrcAndLockClassloader(gradle, buildSrcClassLoaderScope);
        this.delegate.prepareProjects(gradle);
    }

    private void buildBuildSrcAndLockClassloader(GradleInternal gradle, ClassLoaderScope baseProjectClassLoaderScope) {
        ClassPath buildSrcClassPath = this.buildSourceBuilder.buildAndGetClassPath(gradle);
        baseProjectClassLoaderScope.export(buildSrcClassPath).lock();
    }

    private void generateDependenciesAccessorsAndAssignPluginVersions(ServiceRegistry services, SettingsInternal settings, ClassLoaderScope classLoaderScope) {
        DependenciesAccessors accessors = (DependenciesAccessors)services.get(DependenciesAccessors.class);
        DependencyResolutionManagementInternal dm = (DependencyResolutionManagementInternal)services.get(DependencyResolutionManagementInternal.class);
        dm.getDefaultLibrariesExtensionName().finalizeValue();
        String defaultLibrary = (String)dm.getDefaultLibrariesExtensionName().get();
        File dependenciesFile = new File(settings.getSettingsDir(), "gradle/libs.versions.toml");
        if (dependenciesFile.exists()) {
            dm.versionCatalogs(catalogs -> {
                VersionCatalogBuilder builder = (VersionCatalogBuilder)catalogs.findByName(defaultLibrary);
                if (builder == null) {
                    builder = (VersionCatalogBuilder)catalogs.create(defaultLibrary);
                }
                builder.from((Object)((FileCollectionFactory)services.get(FileCollectionFactory.class)).fixed(new File[]{dependenciesFile}));
            });
        }
        accessors.generateAccessors(dm.getDependenciesModelBuilders(), classLoaderScope, settings);
    }
}

