/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceDetails;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.service.ServiceRegistry;

public class ConsumedBuildServiceProvider<T extends BuildService<BuildServiceParameters>>
extends BuildServiceProvider<T, BuildServiceParameters> {
    protected final ServiceRegistry internalServices;
    private final String serviceName;
    private final Class<T> serviceType;
    private final BuildIdentifier buildIdentifier;
    private volatile BuildServiceProvider<T, BuildServiceParameters> resolvedProvider;

    public ConsumedBuildServiceProvider(BuildIdentifier buildIdentifier, String serviceName, Class<T> serviceType, ServiceRegistry internalServices) {
        this.buildIdentifier = buildIdentifier;
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.internalServices = internalServices;
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        BuildServiceProvider<T, BuildServiceParameters> resolvedProvider = this.resolve();
        if (resolvedProvider == null) {
            return ValueSupplier.Value.missing();
        }
        return resolvedProvider.calculateValue(consumer);
    }

    @Nullable
    private BuildServiceProvider<T, BuildServiceParameters> resolve() {
        if (this.resolvedProvider == null) {
            BuildServiceRegistry buildServiceRegistry = (BuildServiceRegistry)this.internalServices.get(BuildServiceRegistry.class);
            BuildServiceRegistration<?, ?> registration = ((BuildServiceRegistryInternal)buildServiceRegistry).findByName(this.serviceName);
            if (registration == null) {
                return null;
            }
            this.resolvedProvider = (BuildServiceProvider)((Object)Cast.uncheckedCast((Object)registration.getService()));
        }
        return this.resolvedProvider;
    }

    @Nullable
    public Class<T> getType() {
        return this.serviceType;
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public BuildServiceDetails<T, BuildServiceParameters> getServiceDetails() {
        BuildServiceProvider<T, BuildServiceParameters> resolvedProvider = this.resolve();
        return resolvedProvider != null ? resolvedProvider.getServiceDetails() : new BuildServiceDetails(this.buildIdentifier, this.serviceName, this.serviceType);
    }
}

