/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.verifier;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.DependencyVerificationException;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.model.ImmutableArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.ImmutableComponentVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

public class DependencyVerifierBuilder {
    private static final Comparator<ModuleComponentIdentifier> MODULE_COMPONENT_IDENTIFIER_COMPARATOR = Comparator.comparing(ModuleComponentIdentifier::getGroup).thenComparing(ModuleComponentIdentifier::getModule).thenComparing(ModuleComponentIdentifier::getVersion);
    private final Map<ModuleComponentIdentifier, ComponentVerificationsBuilder> byComponent = Maps.newHashMap();
    private final List<DependencyVerificationConfiguration.TrustedArtifact> trustedArtifacts = Lists.newArrayList();
    private final Set<DependencyVerificationConfiguration.TrustedKey> trustedKeys = Sets.newLinkedHashSet();
    private final List<URI> keyServers = Lists.newArrayList();
    private final Set<IgnoredKey> ignoredKeys = Sets.newLinkedHashSet();
    private boolean isVerifyMetadata = true;
    private boolean isVerifySignatures = false;
    private boolean useKeyServers = true;
    private final List<String> topLevelComments = Lists.newArrayList();

    public void addTopLevelComment(String comment) {
        this.topLevelComments.add(comment);
    }

    public void addChecksum(ModuleComponentArtifactIdentifier artifact, ChecksumKind kind, String value, @Nullable String origin, @Nullable String reason) {
        ModuleComponentIdentifier componentIdentifier = artifact.getComponentIdentifier();
        this.byComponent.computeIfAbsent(componentIdentifier, x$0 -> new ComponentVerificationsBuilder((ModuleComponentIdentifier)x$0)).addChecksum(artifact, kind, value, origin, reason);
    }

    public void addTrustedKey(ModuleComponentArtifactIdentifier artifact, String key) {
        ModuleComponentIdentifier componentIdentifier = artifact.getComponentIdentifier();
        this.byComponent.computeIfAbsent(componentIdentifier, x$0 -> new ComponentVerificationsBuilder((ModuleComponentIdentifier)x$0)).addTrustedKey(artifact, key);
    }

    public void addIgnoredKey(ModuleComponentArtifactIdentifier artifact, IgnoredKey key) {
        ModuleComponentIdentifier componentIdentifier = artifact.getComponentIdentifier();
        this.byComponent.computeIfAbsent(componentIdentifier, x$0 -> new ComponentVerificationsBuilder((ModuleComponentIdentifier)x$0)).addIgnoredKey(artifact, key);
    }

    public void setVerifyMetadata(boolean verifyMetadata) {
        this.isVerifyMetadata = verifyMetadata;
    }

    public boolean isVerifyMetadata() {
        return this.isVerifyMetadata;
    }

    public boolean isVerifySignatures() {
        return this.isVerifySignatures;
    }

    public void setVerifySignatures(boolean verifySignatures) {
        this.isVerifySignatures = verifySignatures;
    }

    public boolean isUseKeyServers() {
        return this.useKeyServers;
    }

    public void setUseKeyServers(boolean useKeyServers) {
        this.useKeyServers = useKeyServers;
    }

    public List<URI> getKeyServers() {
        return this.keyServers;
    }

    public Set<DependencyVerificationConfiguration.TrustedKey> getTrustedKeys() {
        return this.trustedKeys;
    }

    public void addTrustedArtifact(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
        this.addTrustedArtifact(group, name, version, fileName, regex, null);
    }

    public void addTrustedArtifact(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex, @Nullable String reason) {
        this.validateUserInput(group, name, version, fileName);
        this.trustedArtifacts.add(new DependencyVerificationConfiguration.TrustedArtifact(group, name, version, fileName, regex, reason));
    }

    public void addIgnoredKey(IgnoredKey keyId) {
        this.ignoredKeys.add(keyId);
    }

    public void addTrustedKey(String keyId, @Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
        this.validateUserInput(group, name, version, fileName);
        this.trustedKeys.add(new DependencyVerificationConfiguration.TrustedKey(keyId, group, name, version, fileName, regex));
    }

    private void validateUserInput(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName) {
        if (group == null && name == null && version == null && fileName == null) {
            throw new DependencyVerificationException("A trusted artifact must have at least one of group, name, version or file name not null");
        }
    }

    public DependencyVerifier build() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.byComponent.size());
        this.byComponent.entrySet().stream().sorted(Map.Entry.comparingByKey(MODULE_COMPONENT_IDENTIFIER_COMPARATOR)).forEachOrdered(entry -> builder.put((Object)((ModuleComponentIdentifier)entry.getKey()), (Object)((ComponentVerificationsBuilder)entry.getValue()).build()));
        return new DependencyVerifier((Map<ModuleComponentIdentifier, ComponentVerificationMetadata>)builder.build(), new DependencyVerificationConfiguration(this.isVerifyMetadata, this.isVerifySignatures, this.trustedArtifacts, this.useKeyServers, (List<URI>)ImmutableList.copyOf(this.keyServers), (Set<IgnoredKey>)ImmutableSet.copyOf(this.ignoredKeys), (List<DependencyVerificationConfiguration.TrustedKey>)ImmutableList.copyOf(this.trustedKeys)), this.topLevelComments);
    }

    public List<DependencyVerificationConfiguration.TrustedArtifact> getTrustedArtifacts() {
        return this.trustedArtifacts;
    }

    public void addKeyServer(URI uri) {
        this.keyServers.add(uri);
    }

    private static class ChecksumBuilder {
        private final ChecksumKind kind;
        private String value;
        private String origin;
        private String reason;
        private Set<String> alternatives;

        private ChecksumBuilder(ChecksumKind kind) {
            this.kind = kind;
        }

        void withOrigin(String origin) {
            if (this.origin == null) {
                this.origin = origin;
            }
        }

        void withReason(String reason) {
            if (this.reason == null) {
                this.reason = reason;
            }
        }

        void addChecksum(String checksum) {
            if (this.value == null) {
                this.value = checksum;
            } else if (!this.value.equals(checksum)) {
                if (this.alternatives == null) {
                    this.alternatives = Sets.newLinkedHashSet();
                }
                this.alternatives.add(checksum);
            }
        }

        Checksum build() {
            return new Checksum(this.kind, this.value, this.alternatives, this.origin, this.reason);
        }
    }

    private static class ArtifactVerificationBuilder {
        private final Map<ChecksumKind, ChecksumBuilder> builder = Maps.newEnumMap(ChecksumKind.class);
        private final Set<String> pgpKeys = Sets.newLinkedHashSet();
        private final Set<IgnoredKey> ignoredPgpKeys = Sets.newLinkedHashSet();

        private ArtifactVerificationBuilder() {
        }

        void addChecksum(ChecksumKind kind, String value, @Nullable String origin, @Nullable String reason) {
            ChecksumBuilder builder = this.builder.computeIfAbsent(kind, x$0 -> new ChecksumBuilder((ChecksumKind)((Object)x$0)));
            builder.addChecksum(value);
            if (origin != null) {
                builder.withOrigin(origin);
            }
            if (reason != null) {
                builder.withReason(reason);
            }
        }

        List<Checksum> buildChecksums() {
            return this.builder.values().stream().map(ChecksumBuilder::build).sorted(Comparator.comparing(Checksum::getKind)).collect(Collectors.toList());
        }

        public void addTrustedKey(String key) {
            this.pgpKeys.add(key);
        }

        public void addIgnoredKey(IgnoredKey key) {
            this.ignoredPgpKeys.add(key);
        }

        public Set<String> buildTrustedPgpKeys() {
            return this.pgpKeys;
        }

        public Set<IgnoredKey> buildIgnoredPgpKeys() {
            return this.ignoredPgpKeys;
        }
    }

    private static class ComponentVerificationsBuilder {
        private final ModuleComponentIdentifier component;
        private final Map<String, ArtifactVerificationBuilder> byArtifact = Maps.newHashMap();

        private ComponentVerificationsBuilder(ModuleComponentIdentifier component) {
            this.component = component;
        }

        void addChecksum(ModuleComponentArtifactIdentifier artifact, ChecksumKind kind, String value, @Nullable String origin, @Nullable String reason) {
            this.byArtifact.computeIfAbsent(artifact.getFileName(), id -> new ArtifactVerificationBuilder()).addChecksum(kind, value, origin, reason);
        }

        void addTrustedKey(ModuleComponentArtifactIdentifier artifact, String key) {
            this.byArtifact.computeIfAbsent(artifact.getFileName(), id -> new ArtifactVerificationBuilder()).addTrustedKey(key);
        }

        void addIgnoredKey(ModuleComponentArtifactIdentifier artifact, IgnoredKey key) {
            this.byArtifact.computeIfAbsent(artifact.getFileName(), id -> new ArtifactVerificationBuilder()).addIgnoredKey(key);
        }

        private static ArtifactVerificationMetadata toArtifactVerification(Map.Entry<String, ArtifactVerificationBuilder> entry) {
            String key = entry.getKey();
            ArtifactVerificationBuilder value = entry.getValue();
            return new ImmutableArtifactVerificationMetadata(key, value.buildChecksums(), value.buildTrustedPgpKeys(), value.buildIgnoredPgpKeys());
        }

        ComponentVerificationMetadata build() {
            return new ImmutableComponentVerificationMetadata(this.component, this.byArtifact.entrySet().stream().map(ComponentVerificationsBuilder::toArtifactVerification).sorted(Comparator.comparing(ArtifactVerificationMetadata::getArtifactName)).collect(Collectors.toList()));
        }
    }
}

