/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.cache.CacheConfigurations;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.DefaultCacheCleanup;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanup;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;

public class WritableArtifactCacheLockingManager
implements ArtifactCacheLockingManager,
Closeable {
    private final PersistentCache cache;

    public WritableArtifactCacheLockingManager(CacheRepository cacheRepository, ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CleanupActionDecorator cleanupActionDecorator, CacheConfigurationsInternal cacheConfigurations) {
        this.cache = cacheRepository.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("artifact cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).withCleanup((CacheCleanup)this.createCacheCleanup(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, cleanupActionDecorator, cacheConfigurations)).open();
    }

    private DefaultCacheCleanup createCacheCleanup(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CleanupActionDecorator cleanupActionDecorator, CacheConfigurationsInternal cacheConfigurations) {
        return DefaultCacheCleanup.from((CleanupAction)cleanupActionDecorator.decorate(this.createCleanupAction(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, (CacheConfigurations)cacheConfigurations)), (Provider)cacheConfigurations.getCleanupFrequency());
    }

    private CleanupAction createCleanupAction(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurations cacheConfigurations) {
        return CompositeCleanupAction.builder().add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.ROOT.getName(), (CacheVersionMapping)CacheLayout.ROOT.getVersionMapping(), (UsedGradleVersions)usedGradleVersions)}).add(cacheMetaData.getExternalResourcesStoreDirectory(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.RESOURCES.getName(), (CacheVersionMapping)CacheLayout.RESOURCES.getVersionMapping(), (UsedGradleVersions)usedGradleVersions), new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(2), fileAccessTimeJournal, () -> this.getMaxAgeInDays(cacheConfigurations))}).add(cacheMetaData.getFileStoreDirectory(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.FILE_STORE.getName(), (CacheVersionMapping)CacheLayout.FILE_STORE.getVersionMapping(), (UsedGradleVersions)usedGradleVersions), new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(4), fileAccessTimeJournal, () -> this.getMaxAgeInDays(cacheConfigurations))}).add(cacheMetaData.getMetaDataStoreDirectory().getParentFile(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.META_DATA.getName(), (CacheVersionMapping)CacheLayout.META_DATA.getVersionMapping(), (UsedGradleVersions)usedGradleVersions)}).build();
    }

    private int getMaxAgeInDays(CacheConfigurations cacheConfigurations) {
        return Integer.getInteger("org.gradle.internal.cleanup.external.max.age", (Integer)cacheConfigurations.getDownloadedResources().getRemoveUnusedEntriesAfterDays().get());
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public <T> T withFileLock(Factory<? extends T> action) {
        return (T)this.cache.withFileLock(action);
    }

    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    public <T> T useCache(Factory<? extends T> action) {
        return (T)this.cache.useCache(action);
    }

    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        PersistentIndexedCache persistentCache = this.cache.createCache(PersistentIndexedCacheParameters.of((String)cacheFileInMetaDataStore, keySerializer, valueSerializer));
        return new CacheLockingPersistentCache(persistentCache);
    }

    private class CacheLockingPersistentCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private final PersistentIndexedCache<K, V> persistentCache;

        public CacheLockingPersistentCache(PersistentIndexedCache<K, V> persistentCache) {
            this.persistentCache = persistentCache;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)WritableArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)WritableArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.get(key, producer));
        }

        public void put(K key, V value) {
            WritableArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.put(key, value));
        }

        public void remove(K key) {
            WritableArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.remove(key));
        }
    }
}

