/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.AbstractCacheCleanup;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastRecentlyUsedCacheCleanup
extends AbstractCacheCleanup {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeastRecentlyUsedCacheCleanup.class);
    private final FileAccessTimeJournal journal;
    private final Supplier<Integer> numberOfDays;

    public LeastRecentlyUsedCacheCleanup(FilesFinder eligibleFilesFinder, FileAccessTimeJournal journal, Supplier<Integer> numberOfDays) {
        super(eligibleFilesFinder);
        this.journal = journal;
        this.numberOfDays = numberOfDays;
    }

    private long getMinimumTimestamp() {
        return Math.max(0L, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.numberOfDays.get().intValue()));
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        LOGGER.info("{} removing files not accessed on or after {}.", (Object)cleanableStore.getDisplayName(), (Object)new Date(this.getMinimumTimestamp()));
        super.clean(cleanableStore, progressMonitor);
    }

    @Override
    protected boolean shouldDelete(File file) {
        return this.journal.getLastAccessTime(file) < this.getMinimumTimestamp();
    }

    @Override
    protected void handleDeletion(File file) {
        this.journal.deleteLastAccessTime(file);
    }
}

