/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.normalization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ApiMemberWriter;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;
import org.gradle.kotlin.dsl.normalization.CompileAvoidanceException;
import org.gradle.kotlin.dsl.normalization.KotlinApiMemberWriter;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016J\u0016\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0014J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0019H\u0014J\f\u0010\"\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010#\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010%\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010&\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010'\u001a\u00020(*\u00020\u0019H\u0002J\f\u0010)\u001a\u00020(*\u00020\u0019H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter;", "Lorg/gradle/internal/normalization/java/impl/ApiMemberWriter;", "apiMemberAdapter", "Lorg/objectweb/asm/ClassVisitor;", "(Lorg/objectweb/asm/ClassVisitor;)V", "inlineFunctions", "", "", "getInlineFunctions", "()Ljava/util/Set;", "internalFunctions", "getInternalFunctions", "kotlinMetadataAnnotationSignature", "getKotlinMetadataAnnotationSignature", "()Ljava/lang/String;", "parseKotlinClassHeader", "Lkotlinx/metadata/jvm/KotlinClassHeader;", "kotlinMetadataAnnotation", "Lorg/gradle/internal/normalization/java/impl/AnnotationMember;", "writeClass", "", "classMember", "Lorg/gradle/internal/normalization/java/impl/ClassMember;", "methods", "", "Lorg/gradle/internal/normalization/java/impl/MethodMember;", "fields", "Lorg/gradle/internal/normalization/java/impl/FieldMember;", "innerClasses", "Lorg/gradle/internal/normalization/java/impl/InnerClassMember;", "writeClassAnnotations", "annotationMembers", "writeMethod", "method", "binarySignature", "extractFunctionMetadata", "Lkotlinx/metadata/KmDeclarationContainer;", "extractInlineFunctions", "extractInternalFunctions", "isInline", "", "isInternal", "kotlin-dsl"})
final class KotlinApiMemberWriter
extends ApiMemberWriter {
    @NotNull
    private final String kotlinMetadataAnnotationSignature;
    @NotNull
    private final Set<String> inlineFunctions;
    @NotNull
    private final Set<String> internalFunctions;

    @NotNull
    public final String getKotlinMetadataAnnotationSignature() {
        return this.kotlinMetadataAnnotationSignature;
    }

    @NotNull
    public final Set<String> getInlineFunctions() {
        return this.inlineFunctions;
    }

    @NotNull
    public final Set<String> getInternalFunctions() {
        return this.internalFunctions;
    }

    public void writeClass(@NotNull ClassMember classMember, @NotNull Set<? extends MethodMember> methods, @NotNull Set<? extends FieldMember> fields, @NotNull Set<? extends InnerClassMember> innerClasses) {
        Object v2;
        block9: {
            Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter(innerClasses, (String)"innerClasses");
            SortedSet sortedSet = classMember.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"classMember.annotations");
            Iterable $this$firstOrNull$iv = sortedSet;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationMember it = (AnnotationMember)element$iv;
                boolean bl = false;
                AnnotationMember annotationMember = it;
                Intrinsics.checkNotNullExpressionValue((Object)annotationMember, (String)"it");
                if (!Intrinsics.areEqual((Object)annotationMember.getName(), (Object)this.kotlinMetadataAnnotationSignature)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        AnnotationMember annotationMember = v2;
        if (annotationMember != null) {
            AnnotationMember annotationMember2;
            AnnotationMember it = annotationMember2 = annotationMember;
            boolean bl = false;
            KotlinClassMetadata kotlinMetadata = KotlinClassMetadata.Companion.read(this.parseKotlinClassHeader(it));
            if (kotlinMetadata instanceof KotlinClassMetadata.Class) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.Class)kotlinMetadata).toKmClass());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.FileFacade) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.FileFacade)kotlinMetadata).toKmPackage());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.MultiFileClassPart)kotlinMetadata).toKmPackage());
            } else if (!(kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) && !(kotlinMetadata instanceof KotlinClassMetadata.SyntheticClass) && kotlinMetadata instanceof KotlinClassMetadata.Unknown) {
                throw (Throwable)((Object)new CompileAvoidanceException("Unknown Kotlin metadata with kind: " + kotlinMetadata.getHeader().getKind() + " on class " + classMember.getName() + " - this can happen if this class is compiled with a later Kotlin version than the Kotlin compiler used by Gradle"));
            }
        }
        super.writeClass(classMember, methods, fields, innerClasses);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeClassAnnotations(@NotNull Set<? extends AnnotationMember> annotationMembers) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(annotationMembers, (String)"annotationMembers");
        Iterable iterable = annotationMembers;
        KotlinApiMemberWriter kotlinApiMemberWriter = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationMember it = (AnnotationMember)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.kotlinMetadataAnnotationSignature) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        super.writeClassAnnotations(CollectionsKt.toSet((Iterable)list2));
    }

    protected void writeMethod(@NotNull MethodMember method2) {
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        if (this.isInternal(method2)) {
            return;
        }
        if (this.isInline(method2)) {
            throw (Throwable)((Object)CompileAvoidanceException.Factory.publicInlineFunction(method2));
        }
        super.writeMethod(method2);
    }

    private final void extractFunctionMetadata(KmDeclarationContainer $this$extractFunctionMetadata) {
        this.extractInternalFunctions($this$extractFunctionMetadata);
        this.extractInlineFunctions($this$extractFunctionMetadata);
    }

    private final void extractInlineFunctions(KmDeclarationContainer $this$extractInlineFunctions) {
        CollectionsKt.addAll((Collection)this.inlineFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInlineFunctions.getFunctions()), (Function1)extractInlineFunctions.1.INSTANCE), (Function1)extractInlineFunctions.2.INSTANCE));
    }

    private final void extractInternalFunctions(KmDeclarationContainer $this$extractInternalFunctions) {
        CollectionsKt.addAll((Collection)this.internalFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInternalFunctions.getFunctions()), (Function1)extractInternalFunctions.1.INSTANCE), (Function1)extractInternalFunctions.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinClassHeader parseKotlinClassHeader(AnnotationMember kotlinMetadataAnnotation) {
        Integer kind = null;
        int[] metadataVersion = null;
        String[] data1 = null;
        String[] data2 = null;
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        SortedSet sortedSet = kotlinMetadataAnnotation.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"kotlinMetadataAnnotation.values");
        Iterable $this$forEach$iv = sortedSet;
        boolean $i$f$forEach = false;
        block11: for (Object element$iv : $this$forEach$iv) {
            AnnotationValue[] thisCollection$iv;
            void $this$toTypedArray$iv;
            boolean $i$f$toTypedArray;
            String string2;
            void arrayItem;
            Collection<String> collection;
            void item$iv$iv;
            int n;
            int n2;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv;
            AnnotationValue it;
            block26: {
                String string3;
                AnnotationValue annotationValue;
                block21: {
                    block22: {
                        block25: {
                            block24: {
                                block23: {
                                    it = (AnnotationValue)element$iv;
                                    boolean bl = false;
                                    annotationValue = it;
                                    if (!(annotationValue instanceof SimpleAnnotationValue)) break block21;
                                    AnnotationValue annotationValue2 = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)annotationValue2, (String)"it");
                                    string3 = ((SimpleAnnotationValue)annotationValue2).getName();
                                    switch (string3.hashCode()) {
                                        case 3825: {
                                            if (!string3.equals("xi")) continue block11;
                                            break block22;
                                        }
                                        case 3497: {
                                            if (!string3.equals("mv")) continue block11;
                                            break block23;
                                        }
                                        case 107: {
                                            if (!string3.equals("k")) continue block11;
                                            break;
                                        }
                                        case 3835: {
                                            if (!string3.equals("xs")) continue block11;
                                            break block24;
                                        }
                                        case 3582: {
                                            if (!string3.equals("pn")) continue block11;
                                            break block25;
                                        }
                                    }
                                    Object object = ((SimpleAnnotationValue)it).getValue();
                                    if (object == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                    }
                                    kind = (Integer)object;
                                    continue;
                                }
                                Object object = ((SimpleAnnotationValue)it).getValue();
                                if (object == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                                }
                                metadataVersion = (int[])object;
                                continue;
                            }
                            Object object = ((SimpleAnnotationValue)it).getValue();
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            extraString = (String)object;
                            continue;
                        }
                        Object object = ((SimpleAnnotationValue)it).getValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        packageName = (String)object;
                        continue;
                    }
                    Object object = ((SimpleAnnotationValue)it).getValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    extraInt = (Integer)object;
                    continue;
                }
                if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
                AnnotationValue annotationValue3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)annotationValue3, (String)"it");
                string3 = ((ArrayAnnotationValue)annotationValue3).getName();
                switch (string3.hashCode()) {
                    case 3149: {
                        if (!string3.equals("d1")) continue block11;
                        break;
                    }
                    case 3150: {
                        if (!string3.equals("d2")) continue block11;
                        break block26;
                    }
                }
                AnnotationValue[] annotationValueArray = (AnnotationValue[])((ArrayAnnotationValue)it).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)annotationValueArray, (String)"it.value");
                $this$map$iv = annotationValueArray;
                $i$f$map = false;
                AnnotationValue[] annotationValueArray2 = $this$map$iv;
                destination$iv$iv = new ArrayList(((AnnotationValue[])$this$map$iv).length);
                $i$f$mapTo = false;
                n2 = ((void)$this$mapTo$iv$iv).length;
                for (n = 0; n < n2; ++n) {
                    void var25_25 = item$iv$iv = $this$mapTo$iv$iv[n];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v9 = arrayItem;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"arrayItem");
                    Object object = v9.getValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)object;
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                data1 = thisCollection$iv.toArray(new String[0]);
                continue;
            }
            AnnotationValue[] annotationValueArray = (AnnotationValue[])((ArrayAnnotationValue)it).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)annotationValueArray, (String)"it.value");
            $this$map$iv = annotationValueArray;
            $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(((AnnotationValue[])$this$map$iv).length);
            $i$f$mapTo = false;
            n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                arrayItem = item$iv$iv = $this$mapTo$iv$iv[n];
                collection = destination$iv$iv;
                boolean bl = false;
                void v12 = arrayItem;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"arrayItem");
                Object object = v12.getValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string2 = (String)object;
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            data2 = thisCollection$iv.toArray(new String[0]);
        }
        return new KotlinClassHeader(kind, metadataVersion, data1, data2, extraString, packageName, extraInt);
    }

    private final String binarySignature(MethodMember $this$binarySignature) {
        return $this$binarySignature.getName() + $this$binarySignature.getTypeDesc();
    }

    private final boolean isInternal(MethodMember $this$isInternal) {
        return this.internalFunctions.contains(this.binarySignature($this$isInternal));
    }

    private final boolean isInline(MethodMember $this$isInline) {
        return this.inlineFunctions.contains(this.binarySignature($this$isInline));
    }

    public KotlinApiMemberWriter(@NotNull ClassVisitor apiMemberAdapter) {
        Intrinsics.checkNotNullParameter((Object)apiMemberAdapter, (String)"apiMemberAdapter");
        super(apiMemberAdapter);
        this.kotlinMetadataAnnotationSignature = "Lkotlin/Metadata;";
        this.inlineFunctions = new HashSet();
        this.internalFunctions = new HashSet();
    }
}

