/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.reporting.BuildDashboardReports;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.internal.BuildDashboardGenerator;
import org.gradle.api.reporting.internal.DefaultBuildDashboardReports;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateBuildDashboard
extends DefaultTask
implements Reporting<BuildDashboardReports> {
    private final Set<Reporting<? extends ReportContainer<?>>> aggregated = new LinkedHashSet();
    private final BuildDashboardReports reports = (BuildDashboardReports)this.getInstantiator().newInstance(DefaultBuildDashboardReports.class, new Object[]{this, this.getCollectionCallbackActionDecorator()});

    public GenerateBuildDashboard() {
        this.reports.getHtml().getRequired().set((Object)true);
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CollectionCallbackActionDecorator getCollectionCallbackActionDecorator() {
        throw new UnsupportedOperationException();
    }

    @Input
    public Set<ReportState> getInputReports() {
        LinkedHashSet<ReportState> inputs = new LinkedHashSet<ReportState>();
        for (Report report : this.getEnabledInputReports()) {
            if (this.getReports().contains(report)) continue;
            File outputLocation = ((FileSystemLocation)report.getOutputLocation().get()).getAsFile();
            inputs.add(new ReportState(report.getDisplayName(), outputLocation, outputLocation.exists()));
        }
        return inputs;
    }

    private Set<Report> getEnabledInputReports() {
        HashSet allAggregatedReports = Sets.newHashSet(this.aggregated);
        allAggregatedReports.addAll(this.getAggregatedTasks());
        Set enabledReportSets = CollectionUtils.collect((Set)allAggregatedReports, (Transformer)new Transformer<NamedDomainObjectSet<? extends Report>, Reporting<? extends ReportContainer<?>>>(){

            public NamedDomainObjectSet<? extends Report> transform(Reporting<? extends ReportContainer<?>> reporting) {
                return reporting.getReports().getEnabled();
            }
        });
        return new LinkedHashSet<Report>(CollectionUtils.flattenCollections(Report.class, (Object[])new Object[]{enabledReportSets}));
    }

    private Set<Reporting<? extends ReportContainer<?>>> getAggregatedTasks() {
        final HashSet reports = Sets.newHashSet();
        this.getProject().allprojects((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().all((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (!(task instanceof Reporting)) {
                            return;
                        }
                        reports.add((Reporting)Cast.uncheckedNonnullCast((Object)task));
                    }
                });
            }
        });
        return reports;
    }

    public void aggregate(Reporting<? extends ReportContainer<?>> ... reportings) {
        this.aggregated.addAll(Arrays.asList(reportings));
    }

    @Override
    @Nested
    public BuildDashboardReports getReports() {
        return this.reports;
    }

    @Override
    public BuildDashboardReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public BuildDashboardReports reports(Action<? super BuildDashboardReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @TaskAction
    void run() {
        if (((Boolean)this.getReports().getHtml().getRequired().get()).booleanValue()) {
            BuildDashboardGenerator generator = new BuildDashboardGenerator();
            generator.render(this.getEnabledInputReports(), this.reports.getHtml().getEntryPoint());
        } else {
            this.setDidWork(false);
        }
    }

    private static class ReportState
    implements Serializable {
        private final String name;
        private final File destination;
        private final boolean available;

        private ReportState(String name, File destination, boolean available) {
            this.name = name;
            this.destination = destination;
            this.available = available;
        }

        public boolean equals(Object obj) {
            ReportState other = (ReportState)obj;
            return this.name.equals(other.name) && this.destination.equals(other.destination) && this.available == other.available;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.destination.hashCode();
        }
    }
}

