/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.artifacts.dsl;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.CompileView;
import org.gradle.api.model.ObjectFactory;

@Incubating
public interface Dependencies {
    @Inject
    public DependencyFactory getDependencyFactory();

    @Inject
    public Project getProject();

    default public ProjectDependency project(String projectPath) {
        return this.getDependencyFactory().create(this.getProject().project(projectPath));
    }

    default public ProjectDependency project() {
        return this.getDependencyFactory().create(this.getProject());
    }

    default public ExternalModuleDependency module(CharSequence dependencyNotation) {
        return this.getDependencyFactory().create(dependencyNotation);
    }

    default public ExternalModuleDependency module(@Nullable String group, String name, @Nullable String version) {
        return this.getDependencyFactory().create(group, name, version);
    }

    @Inject
    public ObjectFactory getObjectFactory();

    default public ProjectDependency projectInternalView() {
        ProjectDependency currentProject = this.project();
        currentProject.attributes(attrs -> attrs.attribute(CompileView.VIEW_ATTRIBUTE, this.getObjectFactory().named(CompileView.class, "java-internal")));
        return currentProject;
    }
}

