/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassProcessorFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.internal.Factory;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitTestFramework
implements TestFramework {
    private JUnitOptions options;
    private JUnitDetector detector;
    private final DefaultTestFilter filter;
    private final boolean useImplementationDependencies;
    private final Factory<File> testTaskTemporaryDir;

    public JUnitTestFramework(Test testTask, DefaultTestFilter filter, boolean useImplementationDependencies) {
        this(filter, useImplementationDependencies, new JUnitOptions(), (Factory<File>)testTask.getTemporaryDirFactory());
    }

    private JUnitTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies, JUnitOptions options, Factory<File> testTaskTemporaryDir) {
        this.filter = filter;
        this.useImplementationDependencies = useImplementationDependencies;
        this.options = options;
        this.testTaskTemporaryDir = testTaskTemporaryDir;
        this.detector = new JUnitDetector(new ClassFileExtractionManager(testTaskTemporaryDir));
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitOptions copiedOptions = new JUnitOptions();
        copiedOptions.copyFrom(this.options);
        return new JUnitTestFramework((DefaultTestFilter)newTestFilters, this.useImplementationDependencies, copiedOptions, this.testTaskTemporaryDir);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        return new JUnitTestClassProcessorFactory(new JUnitSpec(this.filter.toSpec(), this.options.getIncludeCategories(), this.options.getExcludeCategories()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> {
            workerProcessBuilder.sharedPackages(new String[]{"junit.framework"});
            workerProcessBuilder.sharedPackages(new String[]{"junit.extensions"});
            workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
        };
    }

    @Override
    public List<String> getTestWorkerApplicationClasses() {
        return Collections.singletonList("junit");
    }

    @Override
    public List<String> getTestWorkerApplicationModules() {
        return Collections.emptyList();
    }

    @Override
    public boolean getUseDistributionDependencies() {
        return this.useImplementationDependencies;
    }

    @Override
    public JUnitOptions getOptions() {
        return this.options;
    }

    void setOptions(JUnitOptions options) {
        this.options = options;
    }

    @Override
    public JUnitDetector getDetector() {
        return this.detector;
    }

    @Override
    public void close() throws IOException {
        this.detector = null;
    }
}

